/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.EventQueryDefinition;
import com.datadog.api.v1.client.model.LogQueryDefinition;
import com.datadog.api.v1.client.model.ProcessQueryDefinition;
import com.datadog.api.v1.client.model.WidgetStyle;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"apm_query", "event_query", "log_query", "network_query", "process_query", "profile_metrics_query", "q", "rum_query", "security_query", "style"})
public class HeatMapWidgetRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_APM_QUERY = "apm_query";
    private LogQueryDefinition apmQuery;
    public static final String JSON_PROPERTY_EVENT_QUERY = "event_query";
    private EventQueryDefinition eventQuery;
    public static final String JSON_PROPERTY_LOG_QUERY = "log_query";
    private LogQueryDefinition logQuery;
    public static final String JSON_PROPERTY_NETWORK_QUERY = "network_query";
    private LogQueryDefinition networkQuery;
    public static final String JSON_PROPERTY_PROCESS_QUERY = "process_query";
    private ProcessQueryDefinition processQuery;
    public static final String JSON_PROPERTY_PROFILE_METRICS_QUERY = "profile_metrics_query";
    private LogQueryDefinition profileMetricsQuery;
    public static final String JSON_PROPERTY_Q = "q";
    private String q;
    public static final String JSON_PROPERTY_RUM_QUERY = "rum_query";
    private LogQueryDefinition rumQuery;
    public static final String JSON_PROPERTY_SECURITY_QUERY = "security_query";
    private LogQueryDefinition securityQuery;
    public static final String JSON_PROPERTY_STYLE = "style";
    private WidgetStyle style;

    public HeatMapWidgetRequest apmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
        this.unparsed |= apmQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="apm_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getApmQuery() {
        return this.apmQuery;
    }

    public void setApmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
    }

    public HeatMapWidgetRequest eventQuery(EventQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
        this.unparsed |= eventQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="event_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EventQueryDefinition getEventQuery() {
        return this.eventQuery;
    }

    public void setEventQuery(EventQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
    }

    public HeatMapWidgetRequest logQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
        this.unparsed |= logQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="log_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getLogQuery() {
        return this.logQuery;
    }

    public void setLogQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
    }

    public HeatMapWidgetRequest networkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
        this.unparsed |= networkQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="network_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getNetworkQuery() {
        return this.networkQuery;
    }

    public void setNetworkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
    }

    public HeatMapWidgetRequest processQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
        this.unparsed |= processQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="process_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessQueryDefinition getProcessQuery() {
        return this.processQuery;
    }

    public void setProcessQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
    }

    public HeatMapWidgetRequest profileMetricsQuery(LogQueryDefinition profileMetricsQuery) {
        this.profileMetricsQuery = profileMetricsQuery;
        this.unparsed |= profileMetricsQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="profile_metrics_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getProfileMetricsQuery() {
        return this.profileMetricsQuery;
    }

    public void setProfileMetricsQuery(LogQueryDefinition profileMetricsQuery) {
        this.profileMetricsQuery = profileMetricsQuery;
    }

    public HeatMapWidgetRequest q(String q) {
        this.q = q;
        return this;
    }

    @Nullable
    @JsonProperty(value="q")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public HeatMapWidgetRequest rumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
        this.unparsed |= rumQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="rum_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getRumQuery() {
        return this.rumQuery;
    }

    public void setRumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
    }

    public HeatMapWidgetRequest securityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
        this.unparsed |= securityQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="security_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getSecurityQuery() {
        return this.securityQuery;
    }

    public void setSecurityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
    }

    public HeatMapWidgetRequest style(WidgetStyle style) {
        this.style = style;
        this.unparsed |= style.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetStyle getStyle() {
        return this.style;
    }

    public void setStyle(WidgetStyle style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeatMapWidgetRequest heatMapWidgetRequest = (HeatMapWidgetRequest)o;
        return Objects.equals(this.apmQuery, heatMapWidgetRequest.apmQuery) && Objects.equals(this.eventQuery, heatMapWidgetRequest.eventQuery) && Objects.equals(this.logQuery, heatMapWidgetRequest.logQuery) && Objects.equals(this.networkQuery, heatMapWidgetRequest.networkQuery) && Objects.equals(this.processQuery, heatMapWidgetRequest.processQuery) && Objects.equals(this.profileMetricsQuery, heatMapWidgetRequest.profileMetricsQuery) && Objects.equals(this.q, heatMapWidgetRequest.q) && Objects.equals(this.rumQuery, heatMapWidgetRequest.rumQuery) && Objects.equals(this.securityQuery, heatMapWidgetRequest.securityQuery) && Objects.equals(this.style, heatMapWidgetRequest.style);
    }

    public int hashCode() {
        return Objects.hash(this.apmQuery, this.eventQuery, this.logQuery, this.networkQuery, this.processQuery, this.profileMetricsQuery, this.q, this.rumQuery, this.securityQuery, this.style);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HeatMapWidgetRequest {\n");
        sb.append("    apmQuery: ").append(this.toIndentedString(this.apmQuery)).append("\n");
        sb.append("    eventQuery: ").append(this.toIndentedString(this.eventQuery)).append("\n");
        sb.append("    logQuery: ").append(this.toIndentedString(this.logQuery)).append("\n");
        sb.append("    networkQuery: ").append(this.toIndentedString(this.networkQuery)).append("\n");
        sb.append("    processQuery: ").append(this.toIndentedString(this.processQuery)).append("\n");
        sb.append("    profileMetricsQuery: ").append(this.toIndentedString(this.profileMetricsQuery)).append("\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    rumQuery: ").append(this.toIndentedString(this.rumQuery)).append("\n");
        sb.append("    securityQuery: ").append(this.toIndentedString(this.securityQuery)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

