/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.GeomapWidgetDefinitionStyle;
import com.datadog.api.v1.client.model.GeomapWidgetDefinitionType;
import com.datadog.api.v1.client.model.GeomapWidgetDefinitionView;
import com.datadog.api.v1.client.model.GeomapWidgetRequest;
import com.datadog.api.v1.client.model.WidgetCustomLink;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"custom_links", "requests", "style", "time", "title", "title_align", "title_size", "type", "view"})
public class GeomapWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<GeomapWidgetRequest> requests = new ArrayList<GeomapWidgetRequest>();
    public static final String JSON_PROPERTY_STYLE = "style";
    private GeomapWidgetDefinitionStyle style;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private GeomapWidgetDefinitionType type = GeomapWidgetDefinitionType.GEOMAP;
    public static final String JSON_PROPERTY_VIEW = "view";
    private GeomapWidgetDefinitionView view;

    public GeomapWidgetDefinition() {
    }

    @JsonCreator
    public GeomapWidgetDefinition(@JsonProperty(required=true, value="requests") List<GeomapWidgetRequest> requests, @JsonProperty(required=true, value="style") GeomapWidgetDefinitionStyle style, @JsonProperty(required=true, value="type") GeomapWidgetDefinitionType type, @JsonProperty(required=true, value="view") GeomapWidgetDefinitionView view) {
        this.requests = requests;
        this.style = style;
        this.unparsed |= style.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
        this.view = view;
        this.unparsed |= view.unparsed;
    }

    public GeomapWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        for (WidgetCustomLink item : customLinks) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public GeomapWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        this.unparsed |= customLinksItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public GeomapWidgetDefinition requests(List<GeomapWidgetRequest> requests) {
        this.requests = requests;
        for (GeomapWidgetRequest item : requests) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public GeomapWidgetDefinition addRequestsItem(GeomapWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        this.unparsed |= requestsItem.unparsed;
        return this;
    }

    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<GeomapWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<GeomapWidgetRequest> requests) {
        this.requests = requests;
    }

    public GeomapWidgetDefinition style(GeomapWidgetDefinitionStyle style) {
        this.style = style;
        this.unparsed |= style.unparsed;
        return this;
    }

    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeomapWidgetDefinitionStyle getStyle() {
        return this.style;
    }

    public void setStyle(GeomapWidgetDefinitionStyle style) {
        this.style = style;
    }

    public GeomapWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public GeomapWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public GeomapWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public GeomapWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public GeomapWidgetDefinition type(GeomapWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeomapWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(GeomapWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public GeomapWidgetDefinition view(GeomapWidgetDefinitionView view) {
        this.view = view;
        this.unparsed |= view.unparsed;
        return this;
    }

    @JsonProperty(value="view")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public GeomapWidgetDefinitionView getView() {
        return this.view;
    }

    public void setView(GeomapWidgetDefinitionView view) {
        this.view = view;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeomapWidgetDefinition geomapWidgetDefinition = (GeomapWidgetDefinition)o;
        return Objects.equals(this.customLinks, geomapWidgetDefinition.customLinks) && Objects.equals(this.requests, geomapWidgetDefinition.requests) && Objects.equals(this.style, geomapWidgetDefinition.style) && Objects.equals(this.time, geomapWidgetDefinition.time) && Objects.equals(this.title, geomapWidgetDefinition.title) && Objects.equals(this.titleAlign, geomapWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, geomapWidgetDefinition.titleSize) && Objects.equals(this.type, geomapWidgetDefinition.type) && Objects.equals(this.view, geomapWidgetDefinition.view);
    }

    public int hashCode() {
        return Objects.hash(this.customLinks, this.requests, this.style, this.time, this.title, this.titleAlign, this.titleSize, this.type, this.view);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeomapWidgetDefinition {\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    view: ").append(this.toIndentedString(this.view)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

