/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.IntakePayloadAccepted;
import com.datadog.api.v1.client.model.ServiceCheck;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class ServiceChecksApi {
    private ApiClient apiClient;

    public ServiceChecksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ServiceChecksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IntakePayloadAccepted submitServiceCheck(List<ServiceCheck> body) throws ApiException {
        return this.submitServiceCheckWithHttpInfo(body).getData();
    }

    public CompletableFuture<IntakePayloadAccepted> submitServiceCheckAsync(List<ServiceCheck> body) {
        return this.submitServiceCheckWithHttpInfoAsync(body).thenApply(response -> (IntakePayloadAccepted)response.getData());
    }

    public ApiResponse<IntakePayloadAccepted> submitServiceCheckWithHttpInfo(List<ServiceCheck> body) throws ApiException {
        List<ServiceCheck> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling submitServiceCheck");
        }
        String localVarPath = "/api/v1/check_run";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("ServiceChecksApi.submitServiceCheck", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"text/json", "application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IntakePayloadAccepted>(){});
    }

    public CompletableFuture<ApiResponse<IntakePayloadAccepted>> submitServiceCheckWithHttpInfoAsync(List<ServiceCheck> body) {
        Invocation.Builder builder;
        List<ServiceCheck> localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<IntakePayloadAccepted>> result = new CompletableFuture<ApiResponse<IntakePayloadAccepted>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling submitServiceCheck"));
            return result;
        }
        String localVarPath = "/api/v1/check_run";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("ServiceChecksApi.submitServiceCheck", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"text/json", "application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IntakePayloadAccepted>> result = new CompletableFuture<ApiResponse<IntakePayloadAccepted>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<IntakePayloadAccepted>(){});
    }
}

