/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.FormulaAndFunctionQueryDefinition;
import com.datadog.api.v1.client.model.FormulaAndFunctionResponseFormat;
import com.datadog.api.v1.client.model.ScatterplotWidgetFormula;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Scatterplot request containing formulas and functions.")
@JsonPropertyOrder(value={"formulas", "queries", "response_format"})
public class ScatterplotTableRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_FORMULAS = "formulas";
    private List<ScatterplotWidgetFormula> formulas = null;
    public static final String JSON_PROPERTY_QUERIES = "queries";
    private List<FormulaAndFunctionQueryDefinition> queries = null;
    public static final String JSON_PROPERTY_RESPONSE_FORMAT = "response_format";
    private FormulaAndFunctionResponseFormat responseFormat;

    public ScatterplotTableRequest formulas(List<ScatterplotWidgetFormula> formulas) {
        this.formulas = formulas;
        for (ScatterplotWidgetFormula item : formulas) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ScatterplotTableRequest addFormulasItem(ScatterplotWidgetFormula formulasItem) {
        if (this.formulas == null) {
            this.formulas = new ArrayList<ScatterplotWidgetFormula>();
        }
        this.formulas.add(formulasItem);
        this.unparsed |= formulasItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of Scatterplot formulas that operate on queries. **This feature is currently in beta.**")
    @JsonProperty(value="formulas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ScatterplotWidgetFormula> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(List<ScatterplotWidgetFormula> formulas) {
        this.formulas = formulas;
    }

    public ScatterplotTableRequest queries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
        for (FormulaAndFunctionQueryDefinition item : queries) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ScatterplotTableRequest addQueriesItem(FormulaAndFunctionQueryDefinition queriesItem) {
        if (this.queries == null) {
            this.queries = new ArrayList<FormulaAndFunctionQueryDefinition>();
        }
        this.queries.add(queriesItem);
        this.unparsed |= queriesItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of queries that can be returned directly or used in formulas. **This feature is currently in beta.**")
    @JsonProperty(value="queries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FormulaAndFunctionQueryDefinition> getQueries() {
        return this.queries;
    }

    public void setQueries(List<FormulaAndFunctionQueryDefinition> queries) {
        this.queries = queries;
    }

    public ScatterplotTableRequest responseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        this.unparsed |= !responseFormat.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="response_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FormulaAndFunctionResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(FormulaAndFunctionResponseFormat responseFormat) {
        if (!responseFormat.isValid()) {
            this.unparsed = true;
        }
        this.responseFormat = responseFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScatterplotTableRequest scatterplotTableRequest = (ScatterplotTableRequest)o;
        return Objects.equals(this.formulas, scatterplotTableRequest.formulas) && Objects.equals(this.queries, scatterplotTableRequest.queries) && Objects.equals(this.responseFormat, scatterplotTableRequest.responseFormat);
    }

    public int hashCode() {
        return Objects.hash(this.formulas, this.queries, this.responseFormat);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScatterplotTableRequest {\n");
        sb.append("    formulas: ").append(this.toIndentedString(this.formulas)).append("\n");
        sb.append("    queries: ").append(this.toIndentedString(this.queries)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString(this.responseFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

