/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.Creator;
import com.datadog.api.v1.client.model.MonitorOverallStates;
import com.datadog.api.v1.client.model.MonitorSearchResultNotification;
import com.datadog.api.v1.client.model.MonitorType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Holds search results.")
@JsonPropertyOrder(value={"classification", "creator", "id", "last_triggered_ts", "metrics", "name", "notifications", "org_id", "query", "scopes", "status", "tags", "type"})
public class MonitorSearchResult {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CLASSIFICATION = "classification";
    private String classification;
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private Creator creator;
    public static final String JSON_PROPERTY_ID = "id";
    private Long id;
    public static final String JSON_PROPERTY_LAST_TRIGGERED_TS = "last_triggered_ts";
    private JsonNullable<Long> lastTriggeredTs = JsonNullable.undefined();
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private List<String> metrics = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
    private List<MonitorSearchResultNotification> notifications = null;
    public static final String JSON_PROPERTY_ORG_ID = "org_id";
    private Long orgId;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private MonitorOverallStates status;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private MonitorType type;

    @Nullable
    @ApiModelProperty(value="Classification of the monitor.")
    @JsonProperty(value="classification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClassification() {
        return this.classification;
    }

    public MonitorSearchResult creator(Creator creator) {
        this.creator = creator;
        this.unparsed |= creator.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    @Nullable
    @ApiModelProperty(value="ID of the monitor.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Latest timestamp the monitor triggered.")
    @JsonIgnore
    public Long getLastTriggeredTs() {
        if (this.lastTriggeredTs == null) {
            this.lastTriggeredTs = JsonNullable.undefined();
        }
        return (Long)this.lastTriggeredTs.orElse(null);
    }

    @JsonProperty(value="last_triggered_ts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getLastTriggeredTs_JsonNullable() {
        return this.lastTriggeredTs;
    }

    @JsonProperty(value="last_triggered_ts")
    private void setLastTriggeredTs_JsonNullable(JsonNullable<Long> lastTriggeredTs) {
        this.lastTriggeredTs = lastTriggeredTs;
    }

    @Nullable
    @ApiModelProperty(value="Metrics used by the monitor.")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getMetrics() {
        return this.metrics;
    }

    @Nullable
    @ApiModelProperty(value="The monitor name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @Nullable
    @ApiModelProperty(value="The notification triggered by the monitor.")
    @JsonProperty(value="notifications")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MonitorSearchResultNotification> getNotifications() {
        return this.notifications;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the organization.")
    @JsonProperty(value="org_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOrgId() {
        return this.orgId;
    }

    public MonitorSearchResult query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="avg(last_5m):sum:system.net.bytes_rcvd{host:host0} > 100", value="The monitor query.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public MonitorSearchResult scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public MonitorSearchResult addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"host:app2\",\"env:dev,env:prod\"]", value="The scope(s) to which the downtime applies, for example `host:app2`. Provide multiple scopes as a comma-separated list, for example `env:dev,env:prod`. The resulting downtime applies to sources that matches ALL provided scopes (that is `env:dev AND env:prod`), NOT any of them.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public MonitorSearchResult status(MonitorOverallStates status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOverallStates getStatus() {
        return this.status;
    }

    public void setStatus(MonitorOverallStates status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    @Nullable
    @ApiModelProperty(value="Tags associated with the monitor.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public MonitorSearchResult type(MonitorType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorType getType() {
        return this.type;
    }

    public void setType(MonitorType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorSearchResult monitorSearchResult = (MonitorSearchResult)o;
        return Objects.equals(this.classification, monitorSearchResult.classification) && Objects.equals(this.creator, monitorSearchResult.creator) && Objects.equals(this.id, monitorSearchResult.id) && Objects.equals(this.lastTriggeredTs, monitorSearchResult.lastTriggeredTs) && Objects.equals(this.metrics, monitorSearchResult.metrics) && Objects.equals(this.name, monitorSearchResult.name) && Objects.equals(this.notifications, monitorSearchResult.notifications) && Objects.equals(this.orgId, monitorSearchResult.orgId) && Objects.equals(this.query, monitorSearchResult.query) && Objects.equals(this.scopes, monitorSearchResult.scopes) && Objects.equals(this.status, monitorSearchResult.status) && Objects.equals(this.tags, monitorSearchResult.tags) && Objects.equals(this.type, monitorSearchResult.type);
    }

    public int hashCode() {
        return Objects.hash(this.classification, this.creator, this.id, this.lastTriggeredTs, this.metrics, this.name, this.notifications, this.orgId, this.query, this.scopes, this.status, this.tags, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorSearchResult {\n");
        sb.append("    classification: ").append(this.toIndentedString(this.classification)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastTriggeredTs: ").append(this.toIndentedString(this.lastTriggeredTs)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notifications: ").append(this.toIndentedString(this.notifications)).append("\n");
        sb.append("    orgId: ").append(this.toIndentedString(this.orgId)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

