/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=HTTPMethodSerializer.class)
public class HTTPMethod {
    public static final HTTPMethod GET = new HTTPMethod("GET");
    public static final HTTPMethod POST = new HTTPMethod("POST");
    public static final HTTPMethod PATCH = new HTTPMethod("PATCH");
    public static final HTTPMethod PUT = new HTTPMethod("PUT");
    public static final HTTPMethod DELETE = new HTTPMethod("DELETE");
    public static final HTTPMethod HEAD = new HTTPMethod("HEAD");
    public static final HTTPMethod OPTIONS = new HTTPMethod("OPTIONS");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("GET", "POST", "PATCH", "PUT", "DELETE", "HEAD", "OPTIONS"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    HTTPMethod(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((HTTPMethod)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static HTTPMethod fromValue(String value) {
        return new HTTPMethod(value);
    }

    public static class HTTPMethodSerializer
    extends StdSerializer<HTTPMethod> {
        public HTTPMethodSerializer(Class<HTTPMethod> t) {
            super(t);
        }

        public HTTPMethodSerializer() {
            this(null);
        }

        public void serialize(HTTPMethod value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

