/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.IdpResponse;
import com.datadog.api.v1.client.model.Organization;
import com.datadog.api.v1.client.model.OrganizationCreateBody;
import com.datadog.api.v1.client.model.OrganizationCreateResponse;
import com.datadog.api.v1.client.model.OrganizationListResponse;
import com.datadog.api.v1.client.model.OrganizationResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;

public class OrganizationsApi {
    private ApiClient apiClient;

    public OrganizationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrganizationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OrganizationCreateResponse createChildOrg(OrganizationCreateBody body) throws ApiException {
        return this.createChildOrgWithHttpInfo(body).getData();
    }

    public CompletableFuture<OrganizationCreateResponse> createChildOrgAsync(OrganizationCreateBody body) {
        return this.createChildOrgWithHttpInfoAsync(body).thenApply(response -> (OrganizationCreateResponse)response.getData());
    }

    public ApiResponse<OrganizationCreateResponse> createChildOrgWithHttpInfo(OrganizationCreateBody body) throws ApiException {
        OrganizationCreateBody localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createChildOrg");
        }
        String localVarPath = "/api/v1/org";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createChildOrg");
        Invocation.Builder builder = this.apiClient.createBuilder("OrganizationsApi.createChildOrg", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrganizationCreateResponse>(){});
    }

    public CompletableFuture<ApiResponse<OrganizationCreateResponse>> createChildOrgWithHttpInfoAsync(OrganizationCreateBody body) {
        Invocation.Builder builder;
        OrganizationCreateBody localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<OrganizationCreateResponse>> result = new CompletableFuture<ApiResponse<OrganizationCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createChildOrg"));
            return result;
        }
        String localVarPath = "/api/v1/org";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createChildOrg");
        try {
            builder = this.apiClient.createBuilder("OrganizationsApi.createChildOrg", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OrganizationCreateResponse>> result = new CompletableFuture<ApiResponse<OrganizationCreateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrganizationCreateResponse>(){});
    }

    public OrganizationResponse getOrg(String publicId) throws ApiException {
        return this.getOrgWithHttpInfo(publicId).getData();
    }

    public CompletableFuture<OrganizationResponse> getOrgAsync(String publicId) {
        return this.getOrgWithHttpInfoAsync(publicId).thenApply(response -> (OrganizationResponse)response.getData());
    }

    public ApiResponse<OrganizationResponse> getOrgWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getOrg");
        }
        String localVarPath = "/api/v1/org/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getOrg");
        Invocation.Builder builder = this.apiClient.createBuilder("OrganizationsApi.getOrg", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrganizationResponse>(){});
    }

    public CompletableFuture<ApiResponse<OrganizationResponse>> getOrgWithHttpInfoAsync(String publicId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (publicId == null) {
            CompletableFuture<ApiResponse<OrganizationResponse>> result = new CompletableFuture<ApiResponse<OrganizationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling getOrg"));
            return result;
        }
        String localVarPath = "/api/v1/org/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getOrg");
        try {
            builder = this.apiClient.createBuilder("OrganizationsApi.getOrg", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OrganizationResponse>> result = new CompletableFuture<ApiResponse<OrganizationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrganizationResponse>(){});
    }

    public OrganizationListResponse listOrgs() throws ApiException {
        return this.listOrgsWithHttpInfo().getData();
    }

    public CompletableFuture<OrganizationListResponse> listOrgsAsync() {
        return this.listOrgsWithHttpInfoAsync().thenApply(response -> (OrganizationListResponse)response.getData());
    }

    public ApiResponse<OrganizationListResponse> listOrgsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/org";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listOrgs");
        Invocation.Builder builder = this.apiClient.createBuilder("OrganizationsApi.listOrgs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrganizationListResponse>(){});
    }

    public CompletableFuture<ApiResponse<OrganizationListResponse>> listOrgsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/org";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listOrgs");
        try {
            builder = this.apiClient.createBuilder("OrganizationsApi.listOrgs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OrganizationListResponse>> result = new CompletableFuture<ApiResponse<OrganizationListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrganizationListResponse>(){});
    }

    public OrganizationResponse updateOrg(String publicId, Organization body) throws ApiException {
        return this.updateOrgWithHttpInfo(publicId, body).getData();
    }

    public CompletableFuture<OrganizationResponse> updateOrgAsync(String publicId, Organization body) {
        return this.updateOrgWithHttpInfoAsync(publicId, body).thenApply(response -> (OrganizationResponse)response.getData());
    }

    public ApiResponse<OrganizationResponse> updateOrgWithHttpInfo(String publicId, Organization body) throws ApiException {
        Organization localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateOrg");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOrg");
        }
        String localVarPath = "/api/v1/org/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateOrg");
        Invocation.Builder builder = this.apiClient.createBuilder("OrganizationsApi.updateOrg", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrganizationResponse>(){});
    }

    public CompletableFuture<ApiResponse<OrganizationResponse>> updateOrgWithHttpInfoAsync(String publicId, Organization body) {
        Invocation.Builder builder;
        Organization localVarPostBody = body;
        if (publicId == null) {
            CompletableFuture<ApiResponse<OrganizationResponse>> result = new CompletableFuture<ApiResponse<OrganizationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling updateOrg"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<OrganizationResponse>> result = new CompletableFuture<ApiResponse<OrganizationResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateOrg"));
            return result;
        }
        String localVarPath = "/api/v1/org/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateOrg");
        try {
            builder = this.apiClient.createBuilder("OrganizationsApi.updateOrg", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OrganizationResponse>> result = new CompletableFuture<ApiResponse<OrganizationResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OrganizationResponse>(){});
    }

    public IdpResponse uploadIdPForOrg(String publicId, File idpFile) throws ApiException {
        return this.uploadIdPForOrgWithHttpInfo(publicId, idpFile).getData();
    }

    public CompletableFuture<IdpResponse> uploadIdPForOrgAsync(String publicId, File idpFile) {
        return this.uploadIdPForOrgWithHttpInfoAsync(publicId, idpFile).thenApply(response -> (IdpResponse)response.getData());
    }

    public ApiResponse<IdpResponse> uploadIdPForOrgWithHttpInfo(String publicId, File idpFile) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling uploadIdPForOrg");
        }
        if (idpFile == null) {
            throw new ApiException(400, "Missing the required parameter 'idpFile' when calling uploadIdPForOrg");
        }
        String localVarPath = "/api/v1/org/{public_id}/idp_metadata".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "uploadIdPForOrg");
        if (idpFile != null) {
            localVarFormParams.put("idp_file", idpFile);
        }
        Invocation.Builder builder = this.apiClient.createBuilder("OrganizationsApi.uploadIdPForOrg", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"multipart/form-data"}, localVarPostBody, localVarFormParams, false, new GenericType<IdpResponse>(){});
    }

    public CompletableFuture<ApiResponse<IdpResponse>> uploadIdPForOrgWithHttpInfoAsync(String publicId, File idpFile) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (publicId == null) {
            CompletableFuture<ApiResponse<IdpResponse>> result = new CompletableFuture<ApiResponse<IdpResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'publicId' when calling uploadIdPForOrg"));
            return result;
        }
        if (idpFile == null) {
            CompletableFuture<ApiResponse<IdpResponse>> result = new CompletableFuture<ApiResponse<IdpResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'idpFile' when calling uploadIdPForOrg"));
            return result;
        }
        String localVarPath = "/api/v1/org/{public_id}/idp_metadata".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "uploadIdPForOrg");
        if (idpFile != null) {
            localVarFormParams.put("idp_file", idpFile);
        }
        try {
            builder = this.apiClient.createBuilder("OrganizationsApi.uploadIdPForOrg", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<IdpResponse>> result = new CompletableFuture<ApiResponse<IdpResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"multipart/form-data"}, localVarPostBody, localVarFormParams, false, new GenericType<IdpResponse>(){});
    }
}

