/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentType;
import com.datadog.api.v2.client.model.IncidentUpdateAttributes;
import com.datadog.api.v2.client.model.IncidentUpdateRelationships;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Incident data for an update request.")
@JsonPropertyOrder(value={"attributes", "id", "relationships", "type"})
public class IncidentUpdateData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private IncidentUpdateAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private IncidentUpdateRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private IncidentType type = IncidentType.INCIDENTS;

    public IncidentUpdateData() {
    }

    @JsonCreator
    public IncidentUpdateData(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") IncidentType type) {
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public IncidentUpdateData attributes(IncidentUpdateAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentUpdateAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(IncidentUpdateAttributes attributes) {
        this.attributes = attributes;
    }

    public IncidentUpdateData id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", required=true, value="The team's ID.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IncidentUpdateData relationships(IncidentUpdateRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentUpdateRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(IncidentUpdateRelationships relationships) {
        this.relationships = relationships;
    }

    public IncidentUpdateData type(IncidentType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentType getType() {
        return this.type;
    }

    public void setType(IncidentType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentUpdateData incidentUpdateData = (IncidentUpdateData)o;
        return Objects.equals(this.attributes, incidentUpdateData.attributes) && Objects.equals(this.id, incidentUpdateData.id) && Objects.equals(this.relationships, incidentUpdateData.relationships) && Objects.equals(this.type, incidentUpdateData.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.relationships, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentUpdateData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

