/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.ApplicationKeyCreateRequest;
import com.datadog.api.v2.client.model.ApplicationKeyResponse;
import com.datadog.api.v2.client.model.ApplicationKeyUpdateRequest;
import com.datadog.api.v2.client.model.ApplicationKeysSort;
import com.datadog.api.v2.client.model.ListApplicationKeysResponse;
import com.datadog.api.v2.client.model.PartialApplicationKeyResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class ServiceAccountsApi {
    private ApiClient apiClient;

    public ServiceAccountsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ServiceAccountsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApplicationKeyResponse createServiceAccountApplicationKey(String serviceAccountId, ApplicationKeyCreateRequest body) throws ApiException {
        return this.createServiceAccountApplicationKeyWithHttpInfo(serviceAccountId, body).getData();
    }

    public ApiResponse<ApplicationKeyResponse> createServiceAccountApplicationKeyWithHttpInfo(String serviceAccountId, ApplicationKeyCreateRequest body) throws ApiException {
        ApplicationKeyCreateRequest localVarPostBody = body;
        if (serviceAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling createServiceAccountApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createServiceAccountApplicationKey");
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createServiceAccountApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ApplicationKeyResponse> localVarReturnType = new GenericType<ApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("ServiceAccountsApi.createServiceAccountApplicationKey", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteServiceAccountApplicationKey(String serviceAccountId, String appKeyId) throws ApiException {
        this.deleteServiceAccountApplicationKeyWithHttpInfo(serviceAccountId, appKeyId);
    }

    public ApiResponse<Void> deleteServiceAccountApplicationKeyWithHttpInfo(String serviceAccountId, String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (serviceAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling deleteServiceAccountApplicationKey");
        }
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling deleteServiceAccountApplicationKey");
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteServiceAccountApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("ServiceAccountsApi.deleteServiceAccountApplicationKey", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public PartialApplicationKeyResponse getServiceAccountApplicationKey(String serviceAccountId, String appKeyId) throws ApiException {
        return this.getServiceAccountApplicationKeyWithHttpInfo(serviceAccountId, appKeyId).getData();
    }

    public ApiResponse<PartialApplicationKeyResponse> getServiceAccountApplicationKeyWithHttpInfo(String serviceAccountId, String appKeyId) throws ApiException {
        Object localVarPostBody = null;
        if (serviceAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling getServiceAccountApplicationKey");
        }
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling getServiceAccountApplicationKey");
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getServiceAccountApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<PartialApplicationKeyResponse> localVarReturnType = new GenericType<PartialApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("ServiceAccountsApi.getServiceAccountApplicationKey", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public ListApplicationKeysResponse listServiceAccountApplicationKeys(String serviceAccountId) throws ApiException {
        return this.listServiceAccountApplicationKeysWithHttpInfo(serviceAccountId, new ListServiceAccountApplicationKeysOptionalParameters()).getData();
    }

    public ListApplicationKeysResponse listServiceAccountApplicationKeys(String serviceAccountId, ListServiceAccountApplicationKeysOptionalParameters parameters) throws ApiException {
        return this.listServiceAccountApplicationKeysWithHttpInfo(serviceAccountId, parameters).getData();
    }

    public ApiResponse<ListApplicationKeysResponse> listServiceAccountApplicationKeysWithHttpInfo(String serviceAccountId, ListServiceAccountApplicationKeysOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (serviceAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling listServiceAccountApplicationKeys");
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        ApplicationKeysSort sort = parameters.sort;
        String filter = parameters.filter;
        String filterCreatedAtStart = parameters.filterCreatedAtStart;
        String filterCreatedAtEnd = parameters.filterCreatedAtEnd;
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][start]", filterCreatedAtStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[created_at][end]", filterCreatedAtEnd));
        localVarHeaderParams.put("DD-OPERATION-ID", "listServiceAccountApplicationKeys");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ListApplicationKeysResponse> localVarReturnType = new GenericType<ListApplicationKeysResponse>(){};
        return this.apiClient.invokeAPI("ServiceAccountsApi.listServiceAccountApplicationKeys", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public PartialApplicationKeyResponse updateServiceAccountApplicationKey(String serviceAccountId, String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        return this.updateServiceAccountApplicationKeyWithHttpInfo(serviceAccountId, appKeyId, body).getData();
    }

    public ApiResponse<PartialApplicationKeyResponse> updateServiceAccountApplicationKeyWithHttpInfo(String serviceAccountId, String appKeyId, ApplicationKeyUpdateRequest body) throws ApiException {
        ApplicationKeyUpdateRequest localVarPostBody = body;
        if (serviceAccountId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceAccountId' when calling updateServiceAccountApplicationKey");
        }
        if (appKeyId == null) {
            throw new ApiException(400, "Missing the required parameter 'appKeyId' when calling updateServiceAccountApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateServiceAccountApplicationKey");
        }
        String localVarPath = "/api/v2/service_accounts/{service_account_id}/application_keys/{app_key_id}".replaceAll("\\{service_account_id\\}", this.apiClient.escapeString(serviceAccountId.toString())).replaceAll("\\{app_key_id\\}", this.apiClient.escapeString(appKeyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateServiceAccountApplicationKey");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<PartialApplicationKeyResponse> localVarReturnType = new GenericType<PartialApplicationKeyResponse>(){};
        return this.apiClient.invokeAPI("ServiceAccountsApi.updateServiceAccountApplicationKey", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListServiceAccountApplicationKeysOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private ApplicationKeysSort sort;
        private String filter;
        private String filterCreatedAtStart;
        private String filterCreatedAtEnd;

        public ListServiceAccountApplicationKeysOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListServiceAccountApplicationKeysOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListServiceAccountApplicationKeysOptionalParameters sort(ApplicationKeysSort sort) {
            this.sort = sort;
            return this;
        }

        public ListServiceAccountApplicationKeysOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ListServiceAccountApplicationKeysOptionalParameters filterCreatedAtStart(String filterCreatedAtStart) {
            this.filterCreatedAtStart = filterCreatedAtStart;
            return this;
        }

        public ListServiceAccountApplicationKeysOptionalParameters filterCreatedAtEnd(String filterCreatedAtEnd) {
            this.filterCreatedAtEnd = filterCreatedAtEnd;
            return this;
        }
    }
}

