/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOHistoryResponseErrorWithType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object that holds an SLI value and its associated data. It can represent an SLO's overall SLI value. This can also represent the SLI value for a specific monitor in multi-monitor SLOs, or a group in grouped SLOs.")
@JsonPropertyOrder(value={"error_budget_remaining", "errors", "group", "history", "monitor_modified", "monitor_type", "name", "precision", "preview", "sli_value", "span_precision", "uptime"})
public class SLOHistoryMonitor {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ERROR_BUDGET_REMAINING = "error_budget_remaining";
    private Map<String, Double> errorBudgetRemaining = null;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<SLOHistoryResponseErrorWithType> errors = null;
    public static final String JSON_PROPERTY_GROUP = "group";
    private String group;
    public static final String JSON_PROPERTY_HISTORY = "history";
    private List<List<Double>> history = null;
    public static final String JSON_PROPERTY_MONITOR_MODIFIED = "monitor_modified";
    private Long monitorModified;
    public static final String JSON_PROPERTY_MONITOR_TYPE = "monitor_type";
    private String monitorType;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRECISION = "precision";
    private Double precision;
    public static final String JSON_PROPERTY_PREVIEW = "preview";
    private Boolean preview;
    public static final String JSON_PROPERTY_SLI_VALUE = "sli_value";
    private Double sliValue;
    public static final String JSON_PROPERTY_SPAN_PRECISION = "span_precision";
    private Double spanPrecision;
    public static final String JSON_PROPERTY_UPTIME = "uptime";
    private Double uptime;

    public SLOHistoryMonitor errorBudgetRemaining(Map<String, Double> errorBudgetRemaining) {
        this.errorBudgetRemaining = errorBudgetRemaining;
        return this;
    }

    public SLOHistoryMonitor putErrorBudgetRemainingItem(String key, Double errorBudgetRemainingItem) {
        if (this.errorBudgetRemaining == null) {
            this.errorBudgetRemaining = new HashMap<String, Double>();
        }
        this.errorBudgetRemaining.put(key, errorBudgetRemainingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"7d\":100.0}", value="A mapping of threshold `timeframe` to the remaining error budget.")
    @JsonProperty(value="error_budget_remaining")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getErrorBudgetRemaining() {
        return this.errorBudgetRemaining;
    }

    public void setErrorBudgetRemaining(Map<String, Double> errorBudgetRemaining) {
        this.errorBudgetRemaining = errorBudgetRemaining;
    }

    public SLOHistoryMonitor errors(List<SLOHistoryResponseErrorWithType> errors) {
        this.errors = errors;
        for (SLOHistoryResponseErrorWithType item : errors) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SLOHistoryMonitor addErrorsItem(SLOHistoryResponseErrorWithType errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<SLOHistoryResponseErrorWithType>();
        }
        this.errors.add(errorsItem);
        this.unparsed |= errorsItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of error objects returned while querying the history data for the service level objective.")
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SLOHistoryResponseErrorWithType> getErrors() {
        return this.errors;
    }

    public void setErrors(List<SLOHistoryResponseErrorWithType> errors) {
        this.errors = errors;
    }

    public SLOHistoryMonitor group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="name", value="For groups in a grouped SLO, this is the group name.")
    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public SLOHistoryMonitor history(List<List<Double>> history) {
        this.history = history;
        return this;
    }

    public SLOHistoryMonitor addHistoryItem(List<Double> historyItem) {
        if (this.history == null) {
            this.history = new ArrayList<List<Double>>();
        }
        this.history.add(historyItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For `monitor` based SLOs, this includes the aggregated history as arrays that include time series and uptime data where `0=monitor` is in `OK` state and `1=monitor` is in `alert` state.")
    @JsonProperty(value="history")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<List<Double>> getHistory() {
        return this.history;
    }

    public void setHistory(List<List<Double>> history) {
        this.history = history;
    }

    public SLOHistoryMonitor monitorModified(Long monitorModified) {
        this.monitorModified = monitorModified;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1615867200", value="For `monitor` based SLOs, this is the last modified timestamp in epoch seconds of the monitor.")
    @JsonProperty(value="monitor_modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMonitorModified() {
        return this.monitorModified;
    }

    public void setMonitorModified(Long monitorModified) {
        this.monitorModified = monitorModified;
    }

    public SLOHistoryMonitor monitorType(String monitorType) {
        this.monitorType = monitorType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="string", value="For `monitor` based SLOs, this describes the type of monitor.")
    @JsonProperty(value="monitor_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMonitorType() {
        return this.monitorType;
    }

    public void setMonitorType(String monitorType) {
        this.monitorType = monitorType;
    }

    public SLOHistoryMonitor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="string", value="For groups in a grouped SLO, this is the group name. For monitors in a multi-monitor SLO, this is the monitor name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SLOHistoryMonitor precision(Double precision) {
        this.precision = precision;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(example="2", value="The amount of decimal places the SLI value is accurate to for the given from `&&` to timestamp. Use `span_precision` instead.")
    @JsonProperty(value="precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getPrecision() {
        return this.precision;
    }

    public void setPrecision(Double precision) {
        this.precision = precision;
    }

    public SLOHistoryMonitor preview(Boolean preview) {
        this.preview = preview;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="For `monitor` based SLOs, when `true` this indicates that a replay is in progress to give an accurate uptime calculation.")
    @JsonProperty(value="preview")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPreview() {
        return this.preview;
    }

    public void setPreview(Boolean preview) {
        this.preview = preview;
    }

    public SLOHistoryMonitor sliValue(Double sliValue) {
        this.sliValue = sliValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="99.99", value="The current SLI value of the SLO over the history window.")
    @JsonProperty(value="sli_value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSliValue() {
        return this.sliValue;
    }

    public void setSliValue(Double sliValue) {
        this.sliValue = sliValue;
    }

    public SLOHistoryMonitor spanPrecision(Double spanPrecision) {
        this.spanPrecision = spanPrecision;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2", value="The amount of decimal places the SLI value is accurate to for the given from `&&` to timestamp.")
    @JsonProperty(value="span_precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSpanPrecision() {
        return this.spanPrecision;
    }

    public void setSpanPrecision(Double spanPrecision) {
        this.spanPrecision = spanPrecision;
    }

    public SLOHistoryMonitor uptime(Double uptime) {
        this.uptime = uptime;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(example="99.99", value="Use `sli_value` instead.")
    @JsonProperty(value="uptime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUptime() {
        return this.uptime;
    }

    public void setUptime(Double uptime) {
        this.uptime = uptime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistoryMonitor slOHistoryMonitor = (SLOHistoryMonitor)o;
        return Objects.equals(this.errorBudgetRemaining, slOHistoryMonitor.errorBudgetRemaining) && Objects.equals(this.errors, slOHistoryMonitor.errors) && Objects.equals(this.group, slOHistoryMonitor.group) && Objects.equals(this.history, slOHistoryMonitor.history) && Objects.equals(this.monitorModified, slOHistoryMonitor.monitorModified) && Objects.equals(this.monitorType, slOHistoryMonitor.monitorType) && Objects.equals(this.name, slOHistoryMonitor.name) && Objects.equals(this.precision, slOHistoryMonitor.precision) && Objects.equals(this.preview, slOHistoryMonitor.preview) && Objects.equals(this.sliValue, slOHistoryMonitor.sliValue) && Objects.equals(this.spanPrecision, slOHistoryMonitor.spanPrecision) && Objects.equals(this.uptime, slOHistoryMonitor.uptime);
    }

    public int hashCode() {
        return Objects.hash(this.errorBudgetRemaining, this.errors, this.group, this.history, this.monitorModified, this.monitorType, this.name, this.precision, this.preview, this.sliValue, this.spanPrecision, this.uptime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistoryMonitor {\n");
        sb.append("    errorBudgetRemaining: ").append(this.toIndentedString(this.errorBudgetRemaining)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("    monitorModified: ").append(this.toIndentedString(this.monitorModified)).append("\n");
        sb.append("    monitorType: ").append(this.toIndentedString(this.monitorType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    preview: ").append(this.toIndentedString(this.preview)).append("\n");
        sb.append("    sliValue: ").append(this.toIndentedString(this.sliValue)).append("\n");
        sb.append("    spanPrecision: ").append(this.toIndentedString(this.spanPrecision)).append("\n");
        sb.append("    uptime: ").append(this.toIndentedString(this.uptime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

