/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.ApiKey;
import com.datadog.api.v1.client.model.ApplicationKey;
import com.datadog.api.v1.client.model.Organization;
import com.datadog.api.v1.client.model.User;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response object for an organization creation.")
@JsonPropertyOrder(value={"api_key", "application_key", "org", "user"})
public class OrganizationCreateResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_KEY = "api_key";
    private ApiKey apiKey;
    public static final String JSON_PROPERTY_APPLICATION_KEY = "application_key";
    private ApplicationKey applicationKey;
    public static final String JSON_PROPERTY_ORG = "org";
    private Organization org;
    public static final String JSON_PROPERTY_USER = "user";
    private User user;

    public OrganizationCreateResponse apiKey(ApiKey apiKey) {
        this.apiKey = apiKey;
        this.unparsed |= apiKey.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="api_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApiKey getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(ApiKey apiKey) {
        this.apiKey = apiKey;
    }

    public OrganizationCreateResponse applicationKey(ApplicationKey applicationKey) {
        this.applicationKey = applicationKey;
        this.unparsed |= applicationKey.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="application_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationKey getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(ApplicationKey applicationKey) {
        this.applicationKey = applicationKey;
    }

    public OrganizationCreateResponse org(Organization org) {
        this.org = org;
        this.unparsed |= org.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="org")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Organization getOrg() {
        return this.org;
    }

    public void setOrg(Organization org) {
        this.org = org;
    }

    public OrganizationCreateResponse user(User user) {
        this.user = user;
        this.unparsed |= user.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationCreateResponse organizationCreateResponse = (OrganizationCreateResponse)o;
        return Objects.equals(this.apiKey, organizationCreateResponse.apiKey) && Objects.equals(this.applicationKey, organizationCreateResponse.applicationKey) && Objects.equals(this.org, organizationCreateResponse.org) && Objects.equals(this.user, organizationCreateResponse.user);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.applicationKey, this.org, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationCreateResponse {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    applicationKey: ").append(this.toIndentedString(this.applicationKey)).append("\n");
        sb.append("    org: ").append(this.toIndentedString(this.org)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

