/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsGeoIPParserType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The GeoIP parser takes an IP address attribute and extracts if available the Continent, Country, Subdivision, and City information in the target attribute path.")
@JsonPropertyOrder(value={"is_enabled", "name", "sources", "target", "type"})
public class LogsGeoIPParser {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target = "network.client.geoip";
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsGeoIPParserType type = LogsGeoIPParserType.GEO_IP_PARSER;

    public LogsGeoIPParser() {
    }

    @JsonCreator
    public LogsGeoIPParser(@JsonProperty(required=true, value="sources") List<String> sources, @JsonProperty(required=true, value="target") String target, @JsonProperty(required=true, value="type") LogsGeoIPParserType type) {
        this.sources = sources;
        this.target = target;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsGeoIPParser isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the processor is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsGeoIPParser name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the processor.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsGeoIPParser sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsGeoIPParser addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @ApiModelProperty(example="[\"network.client.ip\"]", required=true, value="Array of source attributes.")
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsGeoIPParser target(String target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(example="network.client.geoip", required=true, value="Name of the parent attribute that contains all the extracted details from the `sources`.")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsGeoIPParser type(LogsGeoIPParserType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsGeoIPParserType getType() {
        return this.type;
    }

    public void setType(LogsGeoIPParserType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsGeoIPParser logsGeoIPParser = (LogsGeoIPParser)o;
        return Objects.equals(this.isEnabled, logsGeoIPParser.isEnabled) && Objects.equals(this.name, logsGeoIPParser.name) && Objects.equals(this.sources, logsGeoIPParser.sources) && Objects.equals(this.target, logsGeoIPParser.target) && Objects.equals(this.type, logsGeoIPParser.type);
    }

    public int hashCode() {
        return Objects.hash(this.isEnabled, this.name, this.sources, this.target, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsGeoIPParser {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

