/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogContent;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing a log after being processed and stored by Datadog.")
@JsonPropertyOrder(value={"content", "id"})
public class Log {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONTENT = "content";
    private LogContent content;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public Log content(LogContent content) {
        this.content = content;
        this.unparsed |= content.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogContent getContent() {
        return this.content;
    }

    public void setContent(LogContent content) {
        this.content = content;
    }

    public Log id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AAAAAWgN8Xwgr1vKDQAAAABBV2dOOFh3ZzZobm1mWXJFYTR0OA", value="Unique ID of the Log.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Log log = (Log)o;
        return Objects.equals(this.content, log.content) && Objects.equals(this.id, log.id);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Log {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

