/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.HourlyUsageAttributionUsageType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The usage for one set of tags for one hour.")
@JsonPropertyOrder(value={"hour", "org_name", "public_id", "tag_config_source", "tags", "total_usage_sum", "updated_at", "usage_type"})
public class HourlyUsageAttributionBody {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;
    public static final String JSON_PROPERTY_ORG_NAME = "org_name";
    private String orgName;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_TAG_CONFIG_SOURCE = "tag_config_source";
    private String tagConfigSource;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, List<String>> tags = null;
    public static final String JSON_PROPERTY_TOTAL_USAGE_SUM = "total_usage_sum";
    private Double totalUsageSum;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private String updatedAt;
    public static final String JSON_PROPERTY_USAGE_TYPE = "usage_type";
    private HourlyUsageAttributionUsageType usageType;

    public HourlyUsageAttributionBody hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public HourlyUsageAttributionBody orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the organization.")
    @JsonProperty(value="org_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public HourlyUsageAttributionBody publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The organization public ID.")
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public HourlyUsageAttributionBody tagConfigSource(String tagConfigSource) {
        this.tagConfigSource = tagConfigSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The source of the usage attribution tag configuration and the selected tags in the format of `<source_org_name>:::<selected tag 1>///<selected tag 2>///<selected tag 3>`.")
    @JsonProperty(value="tag_config_source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTagConfigSource() {
        return this.tagConfigSource;
    }

    public void setTagConfigSource(String tagConfigSource) {
        this.tagConfigSource = tagConfigSource;
    }

    public HourlyUsageAttributionBody tags(Map<String, List<String>> tags) {
        this.tags = tags;
        return this;
    }

    public HourlyUsageAttributionBody putTagsItem(String key, List<String> tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, List<String>>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Usage Summary by tag name.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, List<String>> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, List<String>> tags) {
        this.tags = tags;
    }

    public HourlyUsageAttributionBody totalUsageSum(Double totalUsageSum) {
        this.totalUsageSum = totalUsageSum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total product usage for the given tags within the hour.")
    @JsonProperty(value="total_usage_sum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTotalUsageSum() {
        return this.totalUsageSum;
    }

    public void setTotalUsageSum(Double totalUsageSum) {
        this.totalUsageSum = totalUsageSum;
    }

    public HourlyUsageAttributionBody updatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Shows the most recent hour in the current month for all organizations where usages are calculated.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public HourlyUsageAttributionBody usageType(HourlyUsageAttributionUsageType usageType) {
        this.usageType = usageType;
        this.unparsed |= !usageType.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="usage_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HourlyUsageAttributionUsageType getUsageType() {
        return this.usageType;
    }

    public void setUsageType(HourlyUsageAttributionUsageType usageType) {
        if (!usageType.isValid()) {
            this.unparsed = true;
        }
        this.usageType = usageType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HourlyUsageAttributionBody hourlyUsageAttributionBody = (HourlyUsageAttributionBody)o;
        return Objects.equals(this.hour, hourlyUsageAttributionBody.hour) && Objects.equals(this.orgName, hourlyUsageAttributionBody.orgName) && Objects.equals(this.publicId, hourlyUsageAttributionBody.publicId) && Objects.equals(this.tagConfigSource, hourlyUsageAttributionBody.tagConfigSource) && Objects.equals(this.tags, hourlyUsageAttributionBody.tags) && Objects.equals(this.totalUsageSum, hourlyUsageAttributionBody.totalUsageSum) && Objects.equals(this.updatedAt, hourlyUsageAttributionBody.updatedAt) && Objects.equals(this.usageType, hourlyUsageAttributionBody.usageType);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.orgName, this.publicId, this.tagConfigSource, this.tags, this.totalUsageSum, this.updatedAt, this.usageType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HourlyUsageAttributionBody {\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("    orgName: ").append(this.toIndentedString(this.orgName)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    tagConfigSource: ").append(this.toIndentedString(this.tagConfigSource)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    totalUsageSum: ").append(this.toIndentedString(this.totalUsageSum)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    usageType: ").append(this.toIndentedString(this.usageType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

