/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.HostMetaInstallMethod;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata associated with your host.")
@JsonPropertyOrder(value={"agent_checks", "agent_version", "cpuCores", "fbsdV", "gohai", "install_method", "macV", "machine", "nixV", "platform", "processor", "pythonV", "socket-fqdn", "socket-hostname", "winV"})
public class HostMeta {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGENT_CHECKS = "agent_checks";
    private List<List<Object>> agentChecks = null;
    public static final String JSON_PROPERTY_AGENT_VERSION = "agent_version";
    private String agentVersion;
    public static final String JSON_PROPERTY_CPU_CORES = "cpuCores";
    private Long cpuCores;
    public static final String JSON_PROPERTY_FBSD_V = "fbsdV";
    private List<String> fbsdV = null;
    public static final String JSON_PROPERTY_GOHAI = "gohai";
    private String gohai;
    public static final String JSON_PROPERTY_INSTALL_METHOD = "install_method";
    private HostMetaInstallMethod installMethod;
    public static final String JSON_PROPERTY_MAC_V = "macV";
    private List<String> macV = null;
    public static final String JSON_PROPERTY_MACHINE = "machine";
    private String machine;
    public static final String JSON_PROPERTY_NIX_V = "nixV";
    private List<String> nixV = null;
    public static final String JSON_PROPERTY_PLATFORM = "platform";
    private String platform;
    public static final String JSON_PROPERTY_PROCESSOR = "processor";
    private String processor;
    public static final String JSON_PROPERTY_PYTHON_V = "pythonV";
    private String pythonV;
    public static final String JSON_PROPERTY_SOCKET_FQDN = "socket-fqdn";
    private String socketFqdn;
    public static final String JSON_PROPERTY_SOCKET_HOSTNAME = "socket-hostname";
    private String socketHostname;
    public static final String JSON_PROPERTY_WIN_V = "winV";
    private List<String> winV = null;

    public HostMeta agentChecks(List<List<Object>> agentChecks) {
        this.agentChecks = agentChecks;
        return this;
    }

    public HostMeta addAgentChecksItem(List<Object> agentChecksItem) {
        if (this.agentChecks == null) {
            this.agentChecks = new ArrayList<List<Object>>();
        }
        this.agentChecks.add(agentChecksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of Agent checks running on the host.")
    @JsonProperty(value="agent_checks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<List<Object>> getAgentChecks() {
        return this.agentChecks;
    }

    public void setAgentChecks(List<List<Object>> agentChecks) {
        this.agentChecks = agentChecks;
    }

    public HostMeta agentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7.32.3", value="The Datadog Agent version.")
    @JsonProperty(value="agent_version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAgentVersion() {
        return this.agentVersion;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public HostMeta cpuCores(Long cpuCores) {
        this.cpuCores = cpuCores;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="The number of cores.")
    @JsonProperty(value="cpuCores")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCpuCores() {
        return this.cpuCores;
    }

    public void setCpuCores(Long cpuCores) {
        this.cpuCores = cpuCores;
    }

    public HostMeta fbsdV(List<String> fbsdV) {
        this.fbsdV = fbsdV;
        return this;
    }

    public HostMeta addFbsdVItem(String fbsdVItem) {
        if (this.fbsdV == null) {
            this.fbsdV = new ArrayList<String>();
        }
        this.fbsdV.add(fbsdVItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of Mac versions.")
    @JsonProperty(value="fbsdV")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFbsdV() {
        return this.fbsdV;
    }

    public void setFbsdV(List<String> fbsdV) {
        this.fbsdV = fbsdV;
    }

    public HostMeta gohai(String gohai) {
        this.gohai = gohai;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{\"cpu\":{\"cache_size\":\"8192 KB\",\"cpu_cores\":\"1\",\"cpu_logical_processors\":\"1\",\"family\":\"6\",\"mhz\":\"2712.000\",\"model\":\"142\",\"model_name\":\"Intel(R) Core(TM) i7-8559U CPU @ 2.70GHz\",\"stepping\":\"10\",\"vendor_id\":\"GenuineIntel\"},\"filesystem\":[{\"kb_size\":\"3966896\",\"mounted_on\":\"/dev\",\"name\":\"udev\"},{\"kb_size\":\"797396\",\"mounted_on\":\"/run\",\"name\":\"tmpfs\"},{\"kb_size\":\"64800356\",\"mounted_on\":\"/\",\"name\":\"/dev/mapper/vagrant--vg-root\"},{\"kb_size\":\"3986972\",\"mounted_on\":\"/dev/shm\",\"name\":\"tmpfs\"},{\"kb_size\":\"5120\",\"mounted_on\":\"/run/lock\",\"name\":\"tmpfs\"},{\"kb_size\":\"3986972\",\"mounted_on\":\"/sys/fs/cgroup\",\"name\":\"tmpfs\"},{\"kb_size\":\"488245288\",\"mounted_on\":\"/vagrant\",\"name\":\"vagrant\"},{\"kb_size\":\"797392\",\"mounted_on\":\"/run/user/1000\",\"name\":\"tmpfs\"}],\"memory\":{\"swap_total\":\"1003516kB\",\"total\":\"7973944kB\"},\"network\":{\"interfaces\":[{\"ipv4\":\"10.0.2.15\",\"ipv4-network\":\"10.0.2.0/24\",\"ipv6\":\"fe80::a00:27ff:fec2:be11\",\"ipv6-network\":\"fe80::/64\",\"macaddress\":\"08:00:27:c2:be:11\",\"name\":\"eth0\"},{\"ipv4\":\"192.168.122.1\",\"ipv4-network\":\"192.168.122.0/24\",\"macaddress\":\"52:54:00:6f:1c:bf\",\"name\":\"virbr0\"}],\"ipaddress\":\"10.0.2.15\",\"ipaddressv6\":\"fe80::a00:27ff:fec2:be11\",\"macaddress\":\"08:00:27:c2:be:11\"},\"platform\":{\"GOOARCH\":\"amd64\",\"GOOS\":\"linux\",\"goV\":\"1.16.7\",\"hardware_platform\":\"x86_64\",\"hostname\":\"vagrant\",\"kernel_name\":\"Linux\",\"kernel_release\":\"4.15.0-29-generic\",\"kernel_version\":\"#31-Ubuntu SMP Tue Jul 17 15:39:52 UTC 2018\",\"machine\":\"x86_64\",\"os\":\"GNU/Linux\",\"processor\":\"x86_64\",\"pythonV\":\"2.7.15rc1\"}}", value="JSON string containing system information.")
    @JsonProperty(value="gohai")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGohai() {
        return this.gohai;
    }

    public void setGohai(String gohai) {
        this.gohai = gohai;
    }

    public HostMeta installMethod(HostMetaInstallMethod installMethod) {
        this.installMethod = installMethod;
        this.unparsed |= installMethod.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="install_method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HostMetaInstallMethod getInstallMethod() {
        return this.installMethod;
    }

    public void setInstallMethod(HostMetaInstallMethod installMethod) {
        this.installMethod = installMethod;
    }

    public HostMeta macV(List<String> macV) {
        this.macV = macV;
        return this;
    }

    public HostMeta addMacVItem(String macVItem) {
        if (this.macV == null) {
            this.macV = new ArrayList<String>();
        }
        this.macV.add(macVItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of Mac versions.")
    @JsonProperty(value="macV")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getMacV() {
        return this.macV;
    }

    public void setMacV(List<String> macV) {
        this.macV = macV;
    }

    public HostMeta machine(String machine) {
        this.machine = machine;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="amd64", value="The machine architecture.")
    @JsonProperty(value="machine")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMachine() {
        return this.machine;
    }

    public void setMachine(String machine) {
        this.machine = machine;
    }

    public HostMeta nixV(List<String> nixV) {
        this.nixV = nixV;
        return this;
    }

    public HostMeta addNixVItem(String nixVItem) {
        if (this.nixV == null) {
            this.nixV = new ArrayList<String>();
        }
        this.nixV.add(nixVItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of Unix versions.")
    @JsonProperty(value="nixV")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNixV() {
        return this.nixV;
    }

    public void setNixV(List<String> nixV) {
        this.nixV = nixV;
    }

    public HostMeta platform(String platform) {
        this.platform = platform;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="linux", value="The OS platform.")
    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public HostMeta processor(String processor) {
        this.processor = processor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Intel(R) Core(TM) i7-8559U CPU @ 2.70GHz", value="The processor.")
    @JsonProperty(value="processor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcessor() {
        return this.processor;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public HostMeta pythonV(String pythonV) {
        this.pythonV = pythonV;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3.8.11", value="The Python version.")
    @JsonProperty(value="pythonV")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPythonV() {
        return this.pythonV;
    }

    public void setPythonV(String pythonV) {
        this.pythonV = pythonV;
    }

    public HostMeta socketFqdn(String socketFqdn) {
        this.socketFqdn = socketFqdn;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="vagrant.vm.", value="The socket fqdn.")
    @JsonProperty(value="socket-fqdn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSocketFqdn() {
        return this.socketFqdn;
    }

    public void setSocketFqdn(String socketFqdn) {
        this.socketFqdn = socketFqdn;
    }

    public HostMeta socketHostname(String socketHostname) {
        this.socketHostname = socketHostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="vagrant", value="The socket hostname.")
    @JsonProperty(value="socket-hostname")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSocketHostname() {
        return this.socketHostname;
    }

    public void setSocketHostname(String socketHostname) {
        this.socketHostname = socketHostname;
    }

    public HostMeta winV(List<String> winV) {
        this.winV = winV;
        return this;
    }

    public HostMeta addWinVItem(String winVItem) {
        if (this.winV == null) {
            this.winV = new ArrayList<String>();
        }
        this.winV.add(winVItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of Windows versions.")
    @JsonProperty(value="winV")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getWinV() {
        return this.winV;
    }

    public void setWinV(List<String> winV) {
        this.winV = winV;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostMeta hostMeta = (HostMeta)o;
        return Objects.equals(this.agentChecks, hostMeta.agentChecks) && Objects.equals(this.agentVersion, hostMeta.agentVersion) && Objects.equals(this.cpuCores, hostMeta.cpuCores) && Objects.equals(this.fbsdV, hostMeta.fbsdV) && Objects.equals(this.gohai, hostMeta.gohai) && Objects.equals(this.installMethod, hostMeta.installMethod) && Objects.equals(this.macV, hostMeta.macV) && Objects.equals(this.machine, hostMeta.machine) && Objects.equals(this.nixV, hostMeta.nixV) && Objects.equals(this.platform, hostMeta.platform) && Objects.equals(this.processor, hostMeta.processor) && Objects.equals(this.pythonV, hostMeta.pythonV) && Objects.equals(this.socketFqdn, hostMeta.socketFqdn) && Objects.equals(this.socketHostname, hostMeta.socketHostname) && Objects.equals(this.winV, hostMeta.winV);
    }

    public int hashCode() {
        return Objects.hash(this.agentChecks, this.agentVersion, this.cpuCores, this.fbsdV, this.gohai, this.installMethod, this.macV, this.machine, this.nixV, this.platform, this.processor, this.pythonV, this.socketFqdn, this.socketHostname, this.winV);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HostMeta {\n");
        sb.append("    agentChecks: ").append(this.toIndentedString(this.agentChecks)).append("\n");
        sb.append("    agentVersion: ").append(this.toIndentedString(this.agentVersion)).append("\n");
        sb.append("    cpuCores: ").append(this.toIndentedString(this.cpuCores)).append("\n");
        sb.append("    fbsdV: ").append(this.toIndentedString(this.fbsdV)).append("\n");
        sb.append("    gohai: ").append(this.toIndentedString(this.gohai)).append("\n");
        sb.append("    installMethod: ").append(this.toIndentedString(this.installMethod)).append("\n");
        sb.append("    macV: ").append(this.toIndentedString(this.macV)).append("\n");
        sb.append("    machine: ").append(this.toIndentedString(this.machine)).append("\n");
        sb.append("    nixV: ").append(this.toIndentedString(this.nixV)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    processor: ").append(this.toIndentedString(this.processor)).append("\n");
        sb.append("    pythonV: ").append(this.toIndentedString(this.pythonV)).append("\n");
        sb.append("    socketFqdn: ").append(this.toIndentedString(this.socketFqdn)).append("\n");
        sb.append("    socketHostname: ").append(this.toIndentedString(this.socketHostname)).append("\n");
        sb.append("    winV: ").append(this.toIndentedString(this.winV)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

