/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.DashboardList;
import com.datadog.api.v1.client.model.DashboardListDeleteResponse;
import com.datadog.api.v1.client.model.DashboardListListResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class DashboardListsApi {
    private ApiClient apiClient;

    public DashboardListsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DashboardListsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public DashboardList createDashboardList(DashboardList body) throws ApiException {
        return this.createDashboardListWithHttpInfo(body).getData();
    }

    public ApiResponse<DashboardList> createDashboardListWithHttpInfo(DashboardList body) throws ApiException {
        DashboardList localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createDashboardList");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardList> localVarReturnType = new GenericType<DashboardList>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.createDashboardList", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public DashboardListDeleteResponse deleteDashboardList(Long listId) throws ApiException {
        return this.deleteDashboardListWithHttpInfo(listId).getData();
    }

    public ApiResponse<DashboardListDeleteResponse> deleteDashboardListWithHttpInfo(Long listId) throws ApiException {
        Object localVarPostBody = null;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling deleteDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteDashboardList");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListDeleteResponse> localVarReturnType = new GenericType<DashboardListDeleteResponse>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.deleteDashboardList", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public DashboardList getDashboardList(Long listId) throws ApiException {
        return this.getDashboardListWithHttpInfo(listId).getData();
    }

    public ApiResponse<DashboardList> getDashboardListWithHttpInfo(Long listId) throws ApiException {
        Object localVarPostBody = null;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling getDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getDashboardList");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardList> localVarReturnType = new GenericType<DashboardList>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.getDashboardList", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public DashboardListListResponse listDashboardLists() throws ApiException {
        return this.listDashboardListsWithHttpInfo().getData();
    }

    public ApiResponse<DashboardListListResponse> listDashboardListsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/dashboard/lists/manual";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listDashboardLists");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardListListResponse> localVarReturnType = new GenericType<DashboardListListResponse>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.listDashboardLists", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public DashboardList updateDashboardList(Long listId, DashboardList body) throws ApiException {
        return this.updateDashboardListWithHttpInfo(listId, body).getData();
    }

    public ApiResponse<DashboardList> updateDashboardListWithHttpInfo(Long listId, DashboardList body) throws ApiException {
        DashboardList localVarPostBody = body;
        if (listId == null) {
            throw new ApiException(400, "Missing the required parameter 'listId' when calling updateDashboardList");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDashboardList");
        }
        String localVarPath = "/api/v1/dashboard/lists/manual/{list_id}".replaceAll("\\{list_id\\}", this.apiClient.escapeString(listId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateDashboardList");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<DashboardList> localVarReturnType = new GenericType<DashboardList>(){};
        return this.apiClient.invokeAPI("DashboardListsApi.updateDashboardList", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

