/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.RelationshipToOrganization;
import com.datadog.api.v2.client.model.RelationshipToOrganizations;
import com.datadog.api.v2.client.model.RelationshipToRoles;
import com.datadog.api.v2.client.model.RelationshipToUsers;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Relationships of the user object returned by the API.")
@JsonPropertyOrder(value={"org", "other_orgs", "other_users", "roles"})
public class UserResponseRelationships {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ORG = "org";
    private RelationshipToOrganization org;
    public static final String JSON_PROPERTY_OTHER_ORGS = "other_orgs";
    private RelationshipToOrganizations otherOrgs;
    public static final String JSON_PROPERTY_OTHER_USERS = "other_users";
    private RelationshipToUsers otherUsers;
    public static final String JSON_PROPERTY_ROLES = "roles";
    private RelationshipToRoles roles;

    public UserResponseRelationships org(RelationshipToOrganization org) {
        this.org = org;
        this.unparsed |= org.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="org")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationshipToOrganization getOrg() {
        return this.org;
    }

    public void setOrg(RelationshipToOrganization org) {
        this.org = org;
    }

    public UserResponseRelationships otherOrgs(RelationshipToOrganizations otherOrgs) {
        this.otherOrgs = otherOrgs;
        this.unparsed |= otherOrgs.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="other_orgs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationshipToOrganizations getOtherOrgs() {
        return this.otherOrgs;
    }

    public void setOtherOrgs(RelationshipToOrganizations otherOrgs) {
        this.otherOrgs = otherOrgs;
    }

    public UserResponseRelationships otherUsers(RelationshipToUsers otherUsers) {
        this.otherUsers = otherUsers;
        this.unparsed |= otherUsers.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="other_users")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationshipToUsers getOtherUsers() {
        return this.otherUsers;
    }

    public void setOtherUsers(RelationshipToUsers otherUsers) {
        this.otherUsers = otherUsers;
    }

    public UserResponseRelationships roles(RelationshipToRoles roles) {
        this.roles = roles;
        this.unparsed |= roles.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationshipToRoles getRoles() {
        return this.roles;
    }

    public void setRoles(RelationshipToRoles roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserResponseRelationships userResponseRelationships = (UserResponseRelationships)o;
        return Objects.equals(this.org, userResponseRelationships.org) && Objects.equals(this.otherOrgs, userResponseRelationships.otherOrgs) && Objects.equals(this.otherUsers, userResponseRelationships.otherUsers) && Objects.equals(this.roles, userResponseRelationships.roles);
    }

    public int hashCode() {
        return Objects.hash(this.org, this.otherOrgs, this.otherUsers, this.roles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserResponseRelationships {\n");
        sb.append("    org: ").append(this.toIndentedString(this.org)).append("\n");
        sb.append("    otherOrgs: ").append(this.toIndentedString(this.otherOrgs)).append("\n");
        sb.append("    otherUsers: ").append(this.toIndentedString(this.otherUsers)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

