/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentIntegrationMetadataType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A relationship reference for an integration metadata object.")
@JsonPropertyOrder(value={"id", "type"})
public class RelationshipToIncidentIntegrationMetadataData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private IncidentIntegrationMetadataType type = IncidentIntegrationMetadataType.INCIDENT_INTEGRATIONS;

    public RelationshipToIncidentIntegrationMetadataData() {
    }

    @JsonCreator
    public RelationshipToIncidentIntegrationMetadataData(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") IncidentIntegrationMetadataType type) {
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public RelationshipToIncidentIntegrationMetadataData id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", required=true, value="A unique identifier that represents the integration metadata.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RelationshipToIncidentIntegrationMetadataData type(IncidentIntegrationMetadataType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentIntegrationMetadataType getType() {
        return this.type;
    }

    public void setType(IncidentIntegrationMetadataType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipToIncidentIntegrationMetadataData relationshipToIncidentIntegrationMetadataData = (RelationshipToIncidentIntegrationMetadataData)o;
        return Objects.equals(this.id, relationshipToIncidentIntegrationMetadataData.id) && Objects.equals(this.type, relationshipToIncidentIntegrationMetadataData.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelationshipToIncidentIntegrationMetadataData {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

