/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.ApplicationKeyResponseIncludedItem;
import com.datadog.api.v2.client.model.PartialApplicationKey;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response for retrieving a partial application key.")
@JsonPropertyOrder(value={"data", "included"})
public class PartialApplicationKeyResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private PartialApplicationKey data;
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<ApplicationKeyResponseIncludedItem> included = null;

    public PartialApplicationKeyResponse data(PartialApplicationKey data) {
        this.data = data;
        this.unparsed |= data.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PartialApplicationKey getData() {
        return this.data;
    }

    public void setData(PartialApplicationKey data) {
        this.data = data;
    }

    public PartialApplicationKeyResponse included(List<ApplicationKeyResponseIncludedItem> included) {
        this.included = included;
        for (ApplicationKeyResponseIncludedItem item : included) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public PartialApplicationKeyResponse addIncludedItem(ApplicationKeyResponseIncludedItem includedItem) {
        if (this.included == null) {
            this.included = new ArrayList<ApplicationKeyResponseIncludedItem>();
        }
        this.included.add(includedItem);
        this.unparsed |= includedItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of objects related to the application key.")
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ApplicationKeyResponseIncludedItem> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<ApplicationKeyResponseIncludedItem> included) {
        this.included = included;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialApplicationKeyResponse partialApplicationKeyResponse = (PartialApplicationKeyResponse)o;
        return Objects.equals(this.data, partialApplicationKeyResponse.data) && Objects.equals(this.included, partialApplicationKeyResponse.included);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartialApplicationKeyResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

