/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentTeamRelationships;
import com.datadog.api.v2.client.model.IncidentTeamResponseAttributes;
import com.datadog.api.v2.client.model.IncidentTeamType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Incident Team data from a response.")
@JsonPropertyOrder(value={"attributes", "id", "relationships", "type"})
public class IncidentTeamResponseData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private IncidentTeamResponseAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private IncidentTeamRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private IncidentTeamType type = IncidentTeamType.TEAMS;

    public IncidentTeamResponseData attributes(IncidentTeamResponseAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentTeamResponseAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(IncidentTeamResponseAttributes attributes) {
        this.attributes = attributes;
    }

    public IncidentTeamResponseData id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="The incident team's ID.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IncidentTeamResponseData relationships(IncidentTeamRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentTeamRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(IncidentTeamRelationships relationships) {
        this.relationships = relationships;
    }

    public IncidentTeamResponseData type(IncidentTeamType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentTeamType getType() {
        return this.type;
    }

    public void setType(IncidentTeamType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentTeamResponseData incidentTeamResponseData = (IncidentTeamResponseData)o;
        return Objects.equals(this.attributes, incidentTeamResponseData.attributes) && Objects.equals(this.id, incidentTeamResponseData.id) && Objects.equals(this.relationships, incidentTeamResponseData.relationships) && Objects.equals(this.type, incidentTeamResponseData.type);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.relationships, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentTeamResponseData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

