/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentServiceIncludedItems;
import com.datadog.api.v2.client.model.IncidentServiceResponseData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response with an incident service payload.")
@JsonPropertyOrder(value={"data", "included"})
public class IncidentServiceResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private IncidentServiceResponseData data;
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<IncidentServiceIncludedItems> included = null;

    public IncidentServiceResponse() {
    }

    @JsonCreator
    public IncidentServiceResponse(@JsonProperty(required=true, value="data") IncidentServiceResponseData data) {
        this.data = data;
        this.unparsed |= data.unparsed;
    }

    public IncidentServiceResponse data(IncidentServiceResponseData data) {
        this.data = data;
        this.unparsed |= data.unparsed;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IncidentServiceResponseData getData() {
        return this.data;
    }

    public void setData(IncidentServiceResponseData data) {
        this.data = data;
    }

    @Nullable
    @ApiModelProperty(value="Included objects from relationships.")
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IncidentServiceIncludedItems> getIncluded() {
        return this.included;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentServiceResponse incidentServiceResponse = (IncidentServiceResponse)o;
        return Objects.equals(this.data, incidentServiceResponse.data) && Objects.equals(this.included, incidentServiceResponse.included);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentServiceResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

