/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.DashboardType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A dashboard within a list.")
@JsonPropertyOrder(value={"id", "type"})
public class DashboardListItemResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private DashboardType type;

    public DashboardListItemResponse() {
    }

    @JsonCreator
    public DashboardListItemResponse(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") DashboardType type) {
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    @ApiModelProperty(example="q5j-nti-fv6", required=true, value="ID of the dashboard.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public DashboardListItemResponse type(DashboardType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DashboardType getType() {
        return this.type;
    }

    public void setType(DashboardType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardListItemResponse dashboardListItemResponse = (DashboardListItemResponse)o;
        return Objects.equals(this.id, dashboardListItemResponse.id) && Objects.equals(this.type, dashboardListItemResponse.type);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardListItemResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

