/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.MetricAllTagsResponse;
import com.datadog.api.v2.client.model.MetricTagConfigurationCreateRequest;
import com.datadog.api.v2.client.model.MetricTagConfigurationMetricTypes;
import com.datadog.api.v2.client.model.MetricTagConfigurationResponse;
import com.datadog.api.v2.client.model.MetricTagConfigurationUpdateRequest;
import com.datadog.api.v2.client.model.MetricVolumesResponse;
import com.datadog.api.v2.client.model.MetricsAndMetricTagConfigurationsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class MetricsApi {
    private ApiClient apiClient;

    public MetricsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MetricsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public MetricTagConfigurationResponse createTagConfiguration(String metricName, MetricTagConfigurationCreateRequest body) throws ApiException {
        return this.createTagConfigurationWithHttpInfo(metricName, body).getData();
    }

    public ApiResponse<MetricTagConfigurationResponse> createTagConfigurationWithHttpInfo(String metricName, MetricTagConfigurationCreateRequest body) throws ApiException {
        MetricTagConfigurationCreateRequest localVarPostBody = body;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling createTagConfiguration");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTagConfiguration");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createTagConfiguration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MetricTagConfigurationResponse> localVarReturnType = new GenericType<MetricTagConfigurationResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.createTagConfiguration", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteTagConfiguration(String metricName) throws ApiException {
        this.deleteTagConfigurationWithHttpInfo(metricName);
    }

    public ApiResponse<Void> deleteTagConfigurationWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling deleteTagConfiguration");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteTagConfiguration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("MetricsApi.deleteTagConfiguration", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public MetricTagConfigurationResponse listTagConfigurationByName(String metricName) throws ApiException {
        return this.listTagConfigurationByNameWithHttpInfo(metricName).getData();
    }

    public ApiResponse<MetricTagConfigurationResponse> listTagConfigurationByNameWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling listTagConfigurationByName");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listTagConfigurationByName");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MetricTagConfigurationResponse> localVarReturnType = new GenericType<MetricTagConfigurationResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.listTagConfigurationByName", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MetricsAndMetricTagConfigurationsResponse listTagConfigurations() throws ApiException {
        return this.listTagConfigurationsWithHttpInfo(new ListTagConfigurationsOptionalParameters()).getData();
    }

    public MetricsAndMetricTagConfigurationsResponse listTagConfigurations(ListTagConfigurationsOptionalParameters parameters) throws ApiException {
        return this.listTagConfigurationsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<MetricsAndMetricTagConfigurationsResponse> listTagConfigurationsWithHttpInfo(ListTagConfigurationsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Boolean filterConfigured = parameters.filterConfigured;
        String filterTagsConfigured = parameters.filterTagsConfigured;
        MetricTagConfigurationMetricTypes filterMetricType = parameters.filterMetricType;
        Boolean filterIncludePercentiles = parameters.filterIncludePercentiles;
        String filterTags = parameters.filterTags;
        Long windowSeconds = parameters.windowSeconds;
        String localVarPath = "/api/v2/metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[configured]", filterConfigured));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags_configured]", filterTagsConfigured));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[metric_type]", filterMetricType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[include_percentiles]", filterIncludePercentiles));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "window[seconds]", windowSeconds));
        localVarHeaderParams.put("DD-OPERATION-ID", "listTagConfigurations");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<MetricsAndMetricTagConfigurationsResponse> localVarReturnType = new GenericType<MetricsAndMetricTagConfigurationsResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.listTagConfigurations", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MetricAllTagsResponse listTagsByMetricName(String metricName) throws ApiException {
        return this.listTagsByMetricNameWithHttpInfo(metricName).getData();
    }

    public ApiResponse<MetricAllTagsResponse> listTagsByMetricNameWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling listTagsByMetricName");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/all-tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listTagsByMetricName");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<MetricAllTagsResponse> localVarReturnType = new GenericType<MetricAllTagsResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.listTagsByMetricName", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MetricVolumesResponse listVolumesByMetricName(String metricName) throws ApiException {
        return this.listVolumesByMetricNameWithHttpInfo(metricName).getData();
    }

    public ApiResponse<MetricVolumesResponse> listVolumesByMetricNameWithHttpInfo(String metricName) throws ApiException {
        Object localVarPostBody = null;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling listVolumesByMetricName");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/volumes".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listVolumesByMetricName");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<MetricVolumesResponse> localVarReturnType = new GenericType<MetricVolumesResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.listVolumesByMetricName", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public MetricTagConfigurationResponse updateTagConfiguration(String metricName, MetricTagConfigurationUpdateRequest body) throws ApiException {
        return this.updateTagConfigurationWithHttpInfo(metricName, body).getData();
    }

    public ApiResponse<MetricTagConfigurationResponse> updateTagConfigurationWithHttpInfo(String metricName, MetricTagConfigurationUpdateRequest body) throws ApiException {
        MetricTagConfigurationUpdateRequest localVarPostBody = body;
        if (metricName == null) {
            throw new ApiException(400, "Missing the required parameter 'metricName' when calling updateTagConfiguration");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTagConfiguration");
        }
        String localVarPath = "/api/v2/metrics/{metric_name}/tags".replaceAll("\\{metric_name\\}", this.apiClient.escapeString(metricName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateTagConfiguration");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<MetricTagConfigurationResponse> localVarReturnType = new GenericType<MetricTagConfigurationResponse>(){};
        return this.apiClient.invokeAPI("MetricsApi.updateTagConfiguration", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListTagConfigurationsOptionalParameters {
        private Boolean filterConfigured;
        private String filterTagsConfigured;
        private MetricTagConfigurationMetricTypes filterMetricType;
        private Boolean filterIncludePercentiles;
        private String filterTags;
        private Long windowSeconds;

        public ListTagConfigurationsOptionalParameters filterConfigured(Boolean filterConfigured) {
            this.filterConfigured = filterConfigured;
            return this;
        }

        public ListTagConfigurationsOptionalParameters filterTagsConfigured(String filterTagsConfigured) {
            this.filterTagsConfigured = filterTagsConfigured;
            return this;
        }

        public ListTagConfigurationsOptionalParameters filterMetricType(MetricTagConfigurationMetricTypes filterMetricType) {
            this.filterMetricType = filterMetricType;
            return this;
        }

        public ListTagConfigurationsOptionalParameters filterIncludePercentiles(Boolean filterIncludePercentiles) {
            this.filterIncludePercentiles = filterIncludePercentiles;
            return this;
        }

        public ListTagConfigurationsOptionalParameters filterTags(String filterTags) {
            this.filterTags = filterTags;
            return this;
        }

        public ListTagConfigurationsOptionalParameters windowSeconds(Long windowSeconds) {
            this.windowSeconds = windowSeconds;
            return this;
        }
    }
}

