/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.LogsArchive;
import com.datadog.api.v2.client.model.LogsArchiveCreateRequest;
import com.datadog.api.v2.client.model.LogsArchiveOrder;
import com.datadog.api.v2.client.model.LogsArchives;
import com.datadog.api.v2.client.model.RelationshipToRole;
import com.datadog.api.v2.client.model.RolesResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class LogsArchivesApi {
    private ApiClient apiClient;

    public LogsArchivesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogsArchivesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void addReadRoleToArchive(String archiveId, RelationshipToRole body) throws ApiException {
        this.addReadRoleToArchiveWithHttpInfo(archiveId, body);
    }

    public ApiResponse<Void> addReadRoleToArchiveWithHttpInfo(String archiveId, RelationshipToRole body) throws ApiException {
        RelationshipToRole localVarPostBody = body;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling addReadRoleToArchive");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addReadRoleToArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "addReadRoleToArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("LogsArchivesApi.addReadRoleToArchive", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public LogsArchive createLogsArchive(LogsArchiveCreateRequest body) throws ApiException {
        return this.createLogsArchiveWithHttpInfo(body).getData();
    }

    public ApiResponse<LogsArchive> createLogsArchiveWithHttpInfo(LogsArchiveCreateRequest body) throws ApiException {
        LogsArchiveCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createLogsArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchive> localVarReturnType = new GenericType<LogsArchive>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.createLogsArchive", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteLogsArchive(String archiveId) throws ApiException {
        this.deleteLogsArchiveWithHttpInfo(archiveId);
    }

    public ApiResponse<Void> deleteLogsArchiveWithHttpInfo(String archiveId) throws ApiException {
        Object localVarPostBody = null;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling deleteLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteLogsArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("LogsArchivesApi.deleteLogsArchive", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public LogsArchive getLogsArchive(String archiveId) throws ApiException {
        return this.getLogsArchiveWithHttpInfo(archiveId).getData();
    }

    public ApiResponse<LogsArchive> getLogsArchiveWithHttpInfo(String archiveId) throws ApiException {
        Object localVarPostBody = null;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling getLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getLogsArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchive> localVarReturnType = new GenericType<LogsArchive>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.getLogsArchive", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public LogsArchiveOrder getLogsArchiveOrder() throws ApiException {
        return this.getLogsArchiveOrderWithHttpInfo().getData();
    }

    public ApiResponse<LogsArchiveOrder> getLogsArchiveOrderWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/archive-order";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getLogsArchiveOrder");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchiveOrder> localVarReturnType = new GenericType<LogsArchiveOrder>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.getLogsArchiveOrder", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public RolesResponse listArchiveReadRoles(String archiveId) throws ApiException {
        return this.listArchiveReadRolesWithHttpInfo(archiveId).getData();
    }

    public ApiResponse<RolesResponse> listArchiveReadRolesWithHttpInfo(String archiveId) throws ApiException {
        Object localVarPostBody = null;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling listArchiveReadRoles");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listArchiveReadRoles");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<RolesResponse> localVarReturnType = new GenericType<RolesResponse>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.listArchiveReadRoles", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public LogsArchives listLogsArchives() throws ApiException {
        return this.listLogsArchivesWithHttpInfo().getData();
    }

    public ApiResponse<LogsArchives> listLogsArchivesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/logs/config/archives";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLogsArchives");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchives> localVarReturnType = new GenericType<LogsArchives>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.listLogsArchives", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void removeRoleFromArchive(String archiveId, RelationshipToRole body) throws ApiException {
        this.removeRoleFromArchiveWithHttpInfo(archiveId, body);
    }

    public ApiResponse<Void> removeRoleFromArchiveWithHttpInfo(String archiveId, RelationshipToRole body) throws ApiException {
        RelationshipToRole localVarPostBody = body;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling removeRoleFromArchive");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling removeRoleFromArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}/readers".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "removeRoleFromArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("LogsArchivesApi.removeRoleFromArchive", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public LogsArchive updateLogsArchive(String archiveId, LogsArchiveCreateRequest body) throws ApiException {
        return this.updateLogsArchiveWithHttpInfo(archiveId, body).getData();
    }

    public ApiResponse<LogsArchive> updateLogsArchiveWithHttpInfo(String archiveId, LogsArchiveCreateRequest body) throws ApiException {
        LogsArchiveCreateRequest localVarPostBody = body;
        if (archiveId == null) {
            throw new ApiException(400, "Missing the required parameter 'archiveId' when calling updateLogsArchive");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsArchive");
        }
        String localVarPath = "/api/v2/logs/config/archives/{archive_id}".replaceAll("\\{archive_id\\}", this.apiClient.escapeString(archiveId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateLogsArchive");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchive> localVarReturnType = new GenericType<LogsArchive>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.updateLogsArchive", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public LogsArchiveOrder updateLogsArchiveOrder(LogsArchiveOrder body) throws ApiException {
        return this.updateLogsArchiveOrderWithHttpInfo(body).getData();
    }

    public ApiResponse<LogsArchiveOrder> updateLogsArchiveOrderWithHttpInfo(LogsArchiveOrder body) throws ApiException {
        LogsArchiveOrder localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateLogsArchiveOrder");
        }
        String localVarPath = "/api/v2/logs/config/archive-order";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateLogsArchiveOrder");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsArchiveOrder> localVarReturnType = new GenericType<LogsArchiveOrder>(){};
        return this.apiClient.invokeAPI("LogsArchivesApi.updateLogsArchiveOrder", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }
}

