/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.IncidentRelatedObject;
import com.datadog.api.v2.client.model.IncidentTeamCreateRequest;
import com.datadog.api.v2.client.model.IncidentTeamResponse;
import com.datadog.api.v2.client.model.IncidentTeamUpdateRequest;
import com.datadog.api.v2.client.model.IncidentTeamsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class IncidentTeamsApi {
    private ApiClient apiClient;

    public IncidentTeamsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IncidentTeamsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IncidentTeamResponse createIncidentTeam(IncidentTeamCreateRequest body) throws ApiException {
        return this.createIncidentTeamWithHttpInfo(body).getData();
    }

    public ApiResponse<IncidentTeamResponse> createIncidentTeamWithHttpInfo(IncidentTeamCreateRequest body) throws ApiException {
        IncidentTeamCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncidentTeam");
        }
        String localVarPath = "/api/v2/teams";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createIncidentTeam");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentTeamResponse> localVarReturnType = new GenericType<IncidentTeamResponse>(){};
        return this.apiClient.invokeAPI("IncidentTeamsApi.createIncidentTeam", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteIncidentTeam(String teamId) throws ApiException {
        this.deleteIncidentTeamWithHttpInfo(teamId);
    }

    public ApiResponse<Void> deleteIncidentTeamWithHttpInfo(String teamId) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling deleteIncidentTeam");
        }
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteIncidentTeam");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("IncidentTeamsApi.deleteIncidentTeam", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public IncidentTeamResponse getIncidentTeam(String teamId) throws ApiException {
        return this.getIncidentTeamWithHttpInfo(teamId, new GetIncidentTeamOptionalParameters()).getData();
    }

    public IncidentTeamResponse getIncidentTeam(String teamId, GetIncidentTeamOptionalParameters parameters) throws ApiException {
        return this.getIncidentTeamWithHttpInfo(teamId, parameters).getData();
    }

    public ApiResponse<IncidentTeamResponse> getIncidentTeamWithHttpInfo(String teamId, GetIncidentTeamOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getIncidentTeam");
        }
        IncidentRelatedObject include = parameters.include;
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIncidentTeam");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentTeamResponse> localVarReturnType = new GenericType<IncidentTeamResponse>(){};
        return this.apiClient.invokeAPI("IncidentTeamsApi.getIncidentTeam", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public IncidentTeamsResponse listIncidentTeams() throws ApiException {
        return this.listIncidentTeamsWithHttpInfo(new ListIncidentTeamsOptionalParameters()).getData();
    }

    public IncidentTeamsResponse listIncidentTeams(ListIncidentTeamsOptionalParameters parameters) throws ApiException {
        return this.listIncidentTeamsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<IncidentTeamsResponse> listIncidentTeamsWithHttpInfo(ListIncidentTeamsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        IncidentRelatedObject include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/teams";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarHeaderParams.put("DD-OPERATION-ID", "listIncidentTeams");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentTeamsResponse> localVarReturnType = new GenericType<IncidentTeamsResponse>(){};
        return this.apiClient.invokeAPI("IncidentTeamsApi.listIncidentTeams", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public IncidentTeamResponse updateIncidentTeam(String teamId, IncidentTeamUpdateRequest body) throws ApiException {
        return this.updateIncidentTeamWithHttpInfo(teamId, body).getData();
    }

    public ApiResponse<IncidentTeamResponse> updateIncidentTeamWithHttpInfo(String teamId, IncidentTeamUpdateRequest body) throws ApiException {
        IncidentTeamUpdateRequest localVarPostBody = body;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling updateIncidentTeam");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentTeam");
        }
        String localVarPath = "/api/v2/teams/{team_id}".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateIncidentTeam");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentTeamResponse> localVarReturnType = new GenericType<IncidentTeamResponse>(){};
        return this.apiClient.invokeAPI("IncidentTeamsApi.updateIncidentTeam", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListIncidentTeamsOptionalParameters {
        private IncidentRelatedObject include;
        private Long pageSize;
        private Long pageOffset;
        private String filter;

        public ListIncidentTeamsOptionalParameters include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }

        public ListIncidentTeamsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListIncidentTeamsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public ListIncidentTeamsOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }
    }

    public static class GetIncidentTeamOptionalParameters {
        private IncidentRelatedObject include;

        public GetIncidentTeamOptionalParameters include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }
    }
}

