/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.HTTPMethod;
import com.datadog.api.v1.client.model.SyntheticsBasicAuth;
import com.datadog.api.v1.client.model.SyntheticsTestRequestCertificate;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object describing the Synthetic test request.")
@JsonPropertyOrder(value={"allow_insecure", "basicAuth", "body", "certificate", "dnsServer", "dnsServerPort", "follow_redirects", "headers", "host", "message", "method", "noSavingResponseBody", "numberOfPackets", "port", "query", "servername", "shouldTrackHops", "timeout", "url"})
public class SyntheticsTestRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALLOW_INSECURE = "allow_insecure";
    private Boolean allowInsecure;
    public static final String JSON_PROPERTY_BASIC_AUTH = "basicAuth";
    private SyntheticsBasicAuth basicAuth;
    public static final String JSON_PROPERTY_BODY = "body";
    private String body;
    public static final String JSON_PROPERTY_CERTIFICATE = "certificate";
    private SyntheticsTestRequestCertificate certificate;
    public static final String JSON_PROPERTY_DNS_SERVER = "dnsServer";
    private String dnsServer;
    public static final String JSON_PROPERTY_DNS_SERVER_PORT = "dnsServerPort";
    private Integer dnsServerPort;
    public static final String JSON_PROPERTY_FOLLOW_REDIRECTS = "follow_redirects";
    private Boolean followRedirects;
    public static final String JSON_PROPERTY_HEADERS = "headers";
    private Map<String, String> headers = null;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_METHOD = "method";
    private HTTPMethod method;
    public static final String JSON_PROPERTY_NO_SAVING_RESPONSE_BODY = "noSavingResponseBody";
    private Boolean noSavingResponseBody;
    public static final String JSON_PROPERTY_NUMBER_OF_PACKETS = "numberOfPackets";
    private Integer numberOfPackets;
    public static final String JSON_PROPERTY_PORT = "port";
    private Long port;
    public static final String JSON_PROPERTY_QUERY = "query";
    private Object query;
    public static final String JSON_PROPERTY_SERVERNAME = "servername";
    private String servername;
    public static final String JSON_PROPERTY_SHOULD_TRACK_HOPS = "shouldTrackHops";
    private Boolean shouldTrackHops;
    public static final String JSON_PROPERTY_TIMEOUT = "timeout";
    private Double timeout;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public SyntheticsTestRequest allowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allows loading insecure content for an HTTP request in a multistep test step.")
    @JsonProperty(value="allow_insecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowInsecure() {
        return this.allowInsecure;
    }

    public void setAllowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
    }

    public SyntheticsTestRequest basicAuth(SyntheticsBasicAuth basicAuth) {
        this.basicAuth = basicAuth;
        this.unparsed |= basicAuth.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="basicAuth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsBasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(SyntheticsBasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }

    public SyntheticsTestRequest body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Body to include in the test.")
    @JsonProperty(value="body")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public SyntheticsTestRequest certificate(SyntheticsTestRequestCertificate certificate) {
        this.certificate = certificate;
        this.unparsed |= certificate.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestRequestCertificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(SyntheticsTestRequestCertificate certificate) {
        this.certificate = certificate;
    }

    public SyntheticsTestRequest dnsServer(String dnsServer) {
        this.dnsServer = dnsServer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNS server to use for DNS tests.")
    @JsonProperty(value="dnsServer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDnsServer() {
        return this.dnsServer;
    }

    public void setDnsServer(String dnsServer) {
        this.dnsServer = dnsServer;
    }

    public SyntheticsTestRequest dnsServerPort(Integer dnsServerPort) {
        this.dnsServerPort = dnsServerPort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNS server port to use for DNS tests.")
    @JsonProperty(value="dnsServerPort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDnsServerPort() {
        return this.dnsServerPort;
    }

    public void setDnsServerPort(Integer dnsServerPort) {
        this.dnsServerPort = dnsServerPort;
    }

    public SyntheticsTestRequest followRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether or not the request follows redirects.")
    @JsonProperty(value="follow_redirects")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public SyntheticsTestRequest headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public SyntheticsTestRequest putHeadersItem(String key, String headersItem) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, headersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Headers to include when performing the test.")
    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public SyntheticsTestRequest host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host name to perform the test with.")
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public SyntheticsTestRequest message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Message to send for UDP or WebSocket tests.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public SyntheticsTestRequest method(HTTPMethod method) {
        this.method = method;
        this.unparsed |= !method.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HTTPMethod getMethod() {
        return this.method;
    }

    public void setMethod(HTTPMethod method) {
        if (!method.isValid()) {
            this.unparsed = true;
        }
        this.method = method;
    }

    public SyntheticsTestRequest noSavingResponseBody(Boolean noSavingResponseBody) {
        this.noSavingResponseBody = noSavingResponseBody;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines whether or not to save the response body.")
    @JsonProperty(value="noSavingResponseBody")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNoSavingResponseBody() {
        return this.noSavingResponseBody;
    }

    public void setNoSavingResponseBody(Boolean noSavingResponseBody) {
        this.noSavingResponseBody = noSavingResponseBody;
    }

    public SyntheticsTestRequest numberOfPackets(Integer numberOfPackets) {
        this.numberOfPackets = numberOfPackets;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of pings to use per test.")
    @JsonProperty(value="numberOfPackets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfPackets() {
        return this.numberOfPackets;
    }

    public void setNumberOfPackets(Integer numberOfPackets) {
        this.numberOfPackets = numberOfPackets;
    }

    public SyntheticsTestRequest port(Long port) {
        this.port = port;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Port to use when performing the test.")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPort() {
        return this.port;
    }

    public void setPort(Long port) {
        this.port = port;
    }

    public SyntheticsTestRequest query(Object query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Query to use for the test.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getQuery() {
        return this.query;
    }

    public void setQuery(Object query) {
        this.query = query;
    }

    public SyntheticsTestRequest servername(String servername) {
        this.servername = servername;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For SSL tests, it specifies on which server you want to initiate the TLS handshake, allowing the server to present one of multiple possible certificates on the same IP address and TCP port number.")
    @JsonProperty(value="servername")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getServername() {
        return this.servername;
    }

    public void setServername(String servername) {
        this.servername = servername;
    }

    public SyntheticsTestRequest shouldTrackHops(Boolean shouldTrackHops) {
        this.shouldTrackHops = shouldTrackHops;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Turns on a traceroute probe to discover all gateways along the path to the host destination.")
    @JsonProperty(value="shouldTrackHops")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShouldTrackHops() {
        return this.shouldTrackHops;
    }

    public void setShouldTrackHops(Boolean shouldTrackHops) {
        this.shouldTrackHops = shouldTrackHops;
    }

    public SyntheticsTestRequest timeout(Double timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timeout in seconds for the test.")
    @JsonProperty(value="timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Double timeout) {
        this.timeout = timeout;
    }

    public SyntheticsTestRequest url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.com", value="URL to perform the test with.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsTestRequest syntheticsTestRequest = (SyntheticsTestRequest)o;
        return Objects.equals(this.allowInsecure, syntheticsTestRequest.allowInsecure) && Objects.equals(this.basicAuth, syntheticsTestRequest.basicAuth) && Objects.equals(this.body, syntheticsTestRequest.body) && Objects.equals(this.certificate, syntheticsTestRequest.certificate) && Objects.equals(this.dnsServer, syntheticsTestRequest.dnsServer) && Objects.equals(this.dnsServerPort, syntheticsTestRequest.dnsServerPort) && Objects.equals(this.followRedirects, syntheticsTestRequest.followRedirects) && Objects.equals(this.headers, syntheticsTestRequest.headers) && Objects.equals(this.host, syntheticsTestRequest.host) && Objects.equals(this.message, syntheticsTestRequest.message) && Objects.equals(this.method, syntheticsTestRequest.method) && Objects.equals(this.noSavingResponseBody, syntheticsTestRequest.noSavingResponseBody) && Objects.equals(this.numberOfPackets, syntheticsTestRequest.numberOfPackets) && Objects.equals(this.port, syntheticsTestRequest.port) && Objects.equals(this.query, syntheticsTestRequest.query) && Objects.equals(this.servername, syntheticsTestRequest.servername) && Objects.equals(this.shouldTrackHops, syntheticsTestRequest.shouldTrackHops) && Objects.equals(this.timeout, syntheticsTestRequest.timeout) && Objects.equals(this.url, syntheticsTestRequest.url);
    }

    public int hashCode() {
        return Objects.hash(this.allowInsecure, this.basicAuth, this.body, this.certificate, this.dnsServer, this.dnsServerPort, this.followRedirects, this.headers, this.host, this.message, this.method, this.noSavingResponseBody, this.numberOfPackets, this.port, this.query, this.servername, this.shouldTrackHops, this.timeout, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsTestRequest {\n");
        sb.append("    allowInsecure: ").append(this.toIndentedString(this.allowInsecure)).append("\n");
        sb.append("    basicAuth: ").append(this.toIndentedString(this.basicAuth)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    dnsServer: ").append(this.toIndentedString(this.dnsServer)).append("\n");
        sb.append("    dnsServerPort: ").append(this.toIndentedString(this.dnsServerPort)).append("\n");
        sb.append("    followRedirects: ").append(this.toIndentedString(this.followRedirects)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    noSavingResponseBody: ").append(this.toIndentedString(this.noSavingResponseBody)).append("\n");
        sb.append("    numberOfPackets: ").append(this.toIndentedString(this.numberOfPackets)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    servername: ").append(this.toIndentedString(this.servername)).append("\n");
        sb.append("    shouldTrackHops: ").append(this.toIndentedString(this.shouldTrackHops)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

