/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.NotebookGlobalTime;
import com.datadog.api.v1.client.model.NotebookMetadata;
import com.datadog.api.v1.client.model.NotebookStatus;
import com.datadog.api.v1.client.model.NotebookUpdateCell;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The data attributes of a notebook.")
@JsonPropertyOrder(value={"cells", "metadata", "name", "status", "time"})
public class NotebookUpdateDataAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CELLS = "cells";
    private List<NotebookUpdateCell> cells = new ArrayList<NotebookUpdateCell>();
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private NotebookMetadata metadata;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private NotebookStatus status = NotebookStatus.PUBLISHED;
    public static final String JSON_PROPERTY_TIME = "time";
    private NotebookGlobalTime time;

    public NotebookUpdateDataAttributes() {
    }

    @JsonCreator
    public NotebookUpdateDataAttributes(@JsonProperty(required=true, value="cells") List<NotebookUpdateCell> cells, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="time") NotebookGlobalTime time) {
        this.cells = cells;
        this.name = name;
        this.time = time;
        this.unparsed |= time.unparsed;
    }

    public NotebookUpdateDataAttributes cells(List<NotebookUpdateCell> cells) {
        this.cells = cells;
        for (NotebookUpdateCell item : cells) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public NotebookUpdateDataAttributes addCellsItem(NotebookUpdateCell cellsItem) {
        this.cells.add(cellsItem);
        this.unparsed |= cellsItem.unparsed;
        return this;
    }

    @ApiModelProperty(example="[{\"attributes\":{\"definition\":{\"text\":\"## Some test markdown\\n\\n```js\\nvar x, y;\\nx = 5;\\ny = 6;\\n```\",\"type\":\"markdown\"}},\"id\":\"bzbycoya\",\"type\":\"notebook_cells\"},{\"attributes\":{\"definition\":{\"requests\":[{\"display_type\":\"line\",\"q\":\"avg:system.load.1{*}\",\"style\":{\"line_type\":\"solid\",\"line_width\":\"normal\",\"palette\":\"dog_classic\"}}],\"show_legend\":true,\"type\":\"timeseries\",\"yaxis\":{\"scale\":\"linear\"}},\"graph_size\":\"m\",\"split_by\":{\"keys\":[],\"tags\":[]},\"time\":null},\"id\":\"9k6bc6xc\",\"type\":\"notebook_cells\"}]", required=true, value="List of cells to display in the notebook.")
    @JsonProperty(value="cells")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<NotebookUpdateCell> getCells() {
        return this.cells;
    }

    public void setCells(List<NotebookUpdateCell> cells) {
        this.cells = cells;
    }

    public NotebookUpdateDataAttributes metadata(NotebookMetadata metadata) {
        this.metadata = metadata;
        this.unparsed |= metadata.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(NotebookMetadata metadata) {
        this.metadata = metadata;
    }

    public NotebookUpdateDataAttributes name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Example Notebook", required=true, value="The name of the notebook.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NotebookUpdateDataAttributes status(NotebookStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotebookStatus getStatus() {
        return this.status;
    }

    public void setStatus(NotebookStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public NotebookUpdateDataAttributes time(NotebookGlobalTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NotebookGlobalTime getTime() {
        return this.time;
    }

    public void setTime(NotebookGlobalTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotebookUpdateDataAttributes notebookUpdateDataAttributes = (NotebookUpdateDataAttributes)o;
        return Objects.equals(this.cells, notebookUpdateDataAttributes.cells) && Objects.equals(this.metadata, notebookUpdateDataAttributes.metadata) && Objects.equals(this.name, notebookUpdateDataAttributes.name) && Objects.equals(this.status, notebookUpdateDataAttributes.status) && Objects.equals(this.time, notebookUpdateDataAttributes.time);
    }

    public int hashCode() {
        return Objects.hash(this.cells, this.metadata, this.name, this.status, this.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotebookUpdateDataAttributes {\n");
        sb.append("    cells: ").append(this.toIndentedString(this.cells)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

