/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Type of aggregation performed in the monitor query.")
@JsonPropertyOrder(value={"group_by", "metric", "type"})
public class MonitorOptionsAggregation {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private String groupBy;
    public static final String JSON_PROPERTY_METRIC = "metric";
    private String metric;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public MonitorOptionsAggregation groupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="host", value="Group to break down the monitor on.")
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public MonitorOptionsAggregation metric(String metric) {
        this.metric = metric;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="metrics.name", value="Metric name used in the monitor.")
    @JsonProperty(value="metric")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public MonitorOptionsAggregation type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="count", value="Metric type used in the monitor.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorOptionsAggregation monitorOptionsAggregation = (MonitorOptionsAggregation)o;
        return Objects.equals(this.groupBy, monitorOptionsAggregation.groupBy) && Objects.equals(this.metric, monitorOptionsAggregation.metric) && Objects.equals(this.type, monitorOptionsAggregation.type);
    }

    public int hashCode() {
        return Objects.hash(this.groupBy, this.metric, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorOptionsAggregation {\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

