/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.IFrameWidgetDefinitionType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The iframe widget allows you to embed a portion of any other web page on your dashboard. Only available on FREE layout dashboards.")
@JsonPropertyOrder(value={"type", "url"})
public class IFrameWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private IFrameWidgetDefinitionType type = IFrameWidgetDefinitionType.IFRAME;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public IFrameWidgetDefinition() {
    }

    @JsonCreator
    public IFrameWidgetDefinition(@JsonProperty(required=true, value="type") IFrameWidgetDefinitionType type, @JsonProperty(required=true, value="url") String url) {
        this.type = type;
        this.unparsed |= !type.isValid();
        this.url = url;
    }

    public IFrameWidgetDefinition type(IFrameWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IFrameWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(IFrameWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public IFrameWidgetDefinition url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="URL of the iframe.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IFrameWidgetDefinition iframeWidgetDefinition = (IFrameWidgetDefinition)o;
        return Objects.equals(this.type, iframeWidgetDefinition.type) && Objects.equals(this.url, iframeWidgetDefinition.url);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IFrameWidgetDefinition {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

