/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Combination of settings to mute a host.")
@JsonPropertyOrder(value={"end", "message", "override"})
public class HostMuteSettings {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_END = "end";
    private Long end;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_OVERRIDE = "override";
    private Boolean override;

    public HostMuteSettings end(Long end) {
        this.end = end;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1579098130", value="POSIX timestamp in seconds when the host is unmuted. If omitted, the host remains muted until explicitly unmuted.")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public HostMuteSettings message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Muting this host for a test!", value="Message to associate with the muting of this host.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public HostMuteSettings override(Boolean override) {
        this.override = override;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="If true and the host is already muted, replaces existing host mute settings.")
    @JsonProperty(value="override")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOverride() {
        return this.override;
    }

    public void setOverride(Boolean override) {
        this.override = override;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostMuteSettings hostMuteSettings = (HostMuteSettings)o;
        return Objects.equals(this.end, hostMuteSettings.end) && Objects.equals(this.message, hostMuteSettings.message) && Objects.equals(this.override, hostMuteSettings.override);
    }

    public int hashCode() {
        return Objects.hash(this.end, this.message, this.override);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HostMuteSettings {\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    override: ").append(this.toIndentedString(this.override)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

