/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.FunnelWidgetDefinitionType;
import com.datadog.api.v1.client.model.FunnelWidgetRequest;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The funnel visualization displays a funnel of user sessions that maps a sequence of view navigation and user interaction in your application. ")
@JsonPropertyOrder(value={"requests", "time", "title", "title_align", "title_size", "type"})
public class FunnelWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<FunnelWidgetRequest> requests = new ArrayList<FunnelWidgetRequest>();
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private FunnelWidgetDefinitionType type = FunnelWidgetDefinitionType.FUNNEL;

    public FunnelWidgetDefinition() {
    }

    @JsonCreator
    public FunnelWidgetDefinition(@JsonProperty(required=true, value="requests") List<FunnelWidgetRequest> requests, @JsonProperty(required=true, value="type") FunnelWidgetDefinitionType type) {
        this.requests = requests;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public FunnelWidgetDefinition requests(List<FunnelWidgetRequest> requests) {
        this.requests = requests;
        for (FunnelWidgetRequest item : requests) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FunnelWidgetDefinition addRequestsItem(FunnelWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        this.unparsed |= requestsItem.unparsed;
        return this;
    }

    @ApiModelProperty(example="[{\"request_type\":\"funnel\"},{\"query\":{\"data_source\":\"rum\",\"query_string\":\"@browser.name:Chrome\",\"steps\":[{\"facet\":\"@view.name\",\"value\":\"/logs\"},{\"facet\":\"@view.name\",\"value\":\"/apm/home\"}]}}]", required=true, value="Request payload used to query items.")
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FunnelWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<FunnelWidgetRequest> requests) {
        this.requests = requests;
    }

    public FunnelWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public FunnelWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public FunnelWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public FunnelWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public FunnelWidgetDefinition type(FunnelWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FunnelWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(FunnelWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunnelWidgetDefinition funnelWidgetDefinition = (FunnelWidgetDefinition)o;
        return Objects.equals(this.requests, funnelWidgetDefinition.requests) && Objects.equals(this.time, funnelWidgetDefinition.time) && Objects.equals(this.title, funnelWidgetDefinition.title) && Objects.equals(this.titleAlign, funnelWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, funnelWidgetDefinition.titleSize) && Objects.equals(this.type, funnelWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(this.requests, this.time, this.title, this.titleAlign, this.titleSize, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunnelWidgetDefinition {\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

