/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.ChangeWidgetDefinitionType;
import com.datadog.api.v1.client.model.ChangeWidgetRequest;
import com.datadog.api.v1.client.model.WidgetCustomLink;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The Change graph shows you the change in a value over the time period chosen.")
@JsonPropertyOrder(value={"custom_links", "requests", "time", "title", "title_align", "title_size", "type"})
public class ChangeWidgetDefinition {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CUSTOM_LINKS = "custom_links";
    private List<WidgetCustomLink> customLinks = null;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<ChangeWidgetRequest> requests = new ArrayList<ChangeWidgetRequest>();
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ChangeWidgetDefinitionType type = ChangeWidgetDefinitionType.CHANGE;

    public ChangeWidgetDefinition() {
    }

    @JsonCreator
    public ChangeWidgetDefinition(@JsonProperty(required=true, value="requests") List<ChangeWidgetRequest> requests, @JsonProperty(required=true, value="type") ChangeWidgetDefinitionType type) {
        this.requests = requests;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public ChangeWidgetDefinition customLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
        for (WidgetCustomLink item : customLinks) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ChangeWidgetDefinition addCustomLinksItem(WidgetCustomLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<WidgetCustomLink>();
        }
        this.customLinks.add(customLinksItem);
        this.unparsed |= customLinksItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of custom links.")
    @JsonProperty(value="custom_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetCustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<WidgetCustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public ChangeWidgetDefinition requests(List<ChangeWidgetRequest> requests) {
        this.requests = requests;
        for (ChangeWidgetRequest item : requests) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ChangeWidgetDefinition addRequestsItem(ChangeWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        this.unparsed |= requestsItem.unparsed;
        return this;
    }

    @ApiModelProperty(example="[{\"q/apm_query/log_query\":\"<METRIC_1>{<SCOPE_1>}\"}]", required=true, value="Array of one request object to display in the widget.  See the dedicated [Request JSON schema documentation](https://docs.datadoghq.com/dashboards/graphing_json/request_json)  to learn how to build the `REQUEST_SCHEMA`.")
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ChangeWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<ChangeWidgetRequest> requests) {
        this.requests = requests;
    }

    public ChangeWidgetDefinition time(WidgetTime time) {
        this.time = time;
        this.unparsed |= time.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public ChangeWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ChangeWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        this.unparsed |= !titleAlign.isValid();
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        if (!titleAlign.isValid()) {
            this.unparsed = true;
        }
        this.titleAlign = titleAlign;
    }

    public ChangeWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public ChangeWidgetDefinition type(ChangeWidgetDefinitionType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ChangeWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(ChangeWidgetDefinitionType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeWidgetDefinition changeWidgetDefinition = (ChangeWidgetDefinition)o;
        return Objects.equals(this.customLinks, changeWidgetDefinition.customLinks) && Objects.equals(this.requests, changeWidgetDefinition.requests) && Objects.equals(this.time, changeWidgetDefinition.time) && Objects.equals(this.title, changeWidgetDefinition.title) && Objects.equals(this.titleAlign, changeWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, changeWidgetDefinition.titleSize) && Objects.equals(this.type, changeWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(this.customLinks, this.requests, this.time, this.title, this.titleAlign, this.titleSize, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChangeWidgetDefinition {\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString(this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

