/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A list of current AWS services for which Datadog offers automatic log collection.")
@JsonPropertyOrder(value={"account_id", "services"})
public class AWSLogsServicesRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_SERVICES = "services";
    private List<String> services = new ArrayList<String>();

    public AWSLogsServicesRequest() {
    }

    @JsonCreator
    public AWSLogsServicesRequest(@JsonProperty(required=true, value="account_id") String accountId, @JsonProperty(required=true, value="services") List<String> services) {
        this.accountId = accountId;
        this.services = services;
    }

    public AWSLogsServicesRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(example="1234567", required=true, value="Your AWS Account ID without dashes.")
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AWSLogsServicesRequest services(List<String> services) {
        this.services = services;
        return this;
    }

    public AWSLogsServicesRequest addServicesItem(String servicesItem) {
        this.services.add(servicesItem);
        return this;
    }

    @ApiModelProperty(example="[\"s3\",\"elb\",\"elbv2\",\"cloudfront\",\"redshift\",\"lambda\"]", required=true, value="Array of services IDs set to enable automatic log collection. Discover the list of available services with the get list of AWS log ready services API endpoint.")
    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSLogsServicesRequest awSLogsServicesRequest = (AWSLogsServicesRequest)o;
        return Objects.equals(this.accountId, awSLogsServicesRequest.accountId) && Objects.equals(this.services, awSLogsServicesRequest.services);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.services);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSLogsServicesRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

