/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="AWS account ID and Lambda ARN.")
@JsonPropertyOrder(value={"account_id", "lambda_arn"})
public class AWSAccountAndLambdaRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_LAMBDA_ARN = "lambda_arn";
    private String lambdaArn;

    public AWSAccountAndLambdaRequest() {
    }

    @JsonCreator
    public AWSAccountAndLambdaRequest(@JsonProperty(required=true, value="account_id") String accountId, @JsonProperty(required=true, value="lambda_arn") String lambdaArn) {
        this.accountId = accountId;
        this.lambdaArn = lambdaArn;
    }

    public AWSAccountAndLambdaRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(example="1234567", required=true, value="Your AWS Account ID without dashes.")
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AWSAccountAndLambdaRequest lambdaArn(String lambdaArn) {
        this.lambdaArn = lambdaArn;
        return this;
    }

    @ApiModelProperty(example="arn:aws:lambda:us-east-1:1234567:function:LogsCollectionAPITest", required=true, value="ARN of the Datadog Lambda created during the Datadog-Amazon Web services Log collection setup.")
    @JsonProperty(value="lambda_arn")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLambdaArn() {
        return this.lambdaArn;
    }

    public void setLambdaArn(String lambdaArn) {
        this.lambdaArn = lambdaArn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSAccountAndLambdaRequest awSAccountAndLambdaRequest = (AWSAccountAndLambdaRequest)o;
        return Objects.equals(this.accountId, awSAccountAndLambdaRequest.accountId) && Objects.equals(this.lambdaArn, awSAccountAndLambdaRequest.lambdaArn);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.lambdaArn);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSAccountAndLambdaRequest {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    lambdaArn: ").append(this.toIndentedString(this.lambdaArn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

