/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.CancelDowntimesByScopeRequest;
import com.datadog.api.v1.client.model.CanceledDowntimesIds;
import com.datadog.api.v1.client.model.Downtime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class DowntimesApi {
    private ApiClient apiClient;

    public DowntimesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DowntimesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void cancelDowntime(Long downtimeId) throws ApiException {
        this.cancelDowntimeWithHttpInfo(downtimeId);
    }

    public ApiResponse<Void> cancelDowntimeWithHttpInfo(Long downtimeId) throws ApiException {
        Object localVarPostBody = null;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling cancelDowntime");
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "cancelDowntime");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("DowntimesApi.cancelDowntime", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public CanceledDowntimesIds cancelDowntimesByScope(CancelDowntimesByScopeRequest body) throws ApiException {
        return this.cancelDowntimesByScopeWithHttpInfo(body).getData();
    }

    public ApiResponse<CanceledDowntimesIds> cancelDowntimesByScopeWithHttpInfo(CancelDowntimesByScopeRequest body) throws ApiException {
        CancelDowntimesByScopeRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling cancelDowntimesByScope");
        }
        String localVarPath = "/api/v1/downtime/cancel/by_scope";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "cancelDowntimesByScope");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<CanceledDowntimesIds> localVarReturnType = new GenericType<CanceledDowntimesIds>(){};
        return this.apiClient.invokeAPI("DowntimesApi.cancelDowntimesByScope", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Downtime createDowntime(Downtime body) throws ApiException {
        return this.createDowntimeWithHttpInfo(body).getData();
    }

    public ApiResponse<Downtime> createDowntimeWithHttpInfo(Downtime body) throws ApiException {
        Downtime localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createDowntime");
        }
        String localVarPath = "/api/v1/downtime";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createDowntime");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<Downtime> localVarReturnType = new GenericType<Downtime>(){};
        return this.apiClient.invokeAPI("DowntimesApi.createDowntime", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Downtime getDowntime(Long downtimeId) throws ApiException {
        return this.getDowntimeWithHttpInfo(downtimeId).getData();
    }

    public ApiResponse<Downtime> getDowntimeWithHttpInfo(Long downtimeId) throws ApiException {
        Object localVarPostBody = null;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling getDowntime");
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getDowntime");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<Downtime> localVarReturnType = new GenericType<Downtime>(){};
        return this.apiClient.invokeAPI("DowntimesApi.getDowntime", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public List<Downtime> listDowntimes() throws ApiException {
        return this.listDowntimesWithHttpInfo(new ListDowntimesOptionalParameters()).getData();
    }

    public List<Downtime> listDowntimes(ListDowntimesOptionalParameters parameters) throws ApiException {
        return this.listDowntimesWithHttpInfo(parameters).getData();
    }

    public ApiResponse<List<Downtime>> listDowntimesWithHttpInfo(ListDowntimesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Boolean currentOnly = parameters.currentOnly;
        String localVarPath = "/api/v1/downtime";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "current_only", currentOnly));
        localVarHeaderParams.put("DD-OPERATION-ID", "listDowntimes");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<List<Downtime>> localVarReturnType = new GenericType<List<Downtime>>(){};
        return this.apiClient.invokeAPI("DowntimesApi.listDowntimes", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public List<Downtime> listMonitorDowntimes(Long monitorId) throws ApiException {
        return this.listMonitorDowntimesWithHttpInfo(monitorId).getData();
    }

    public ApiResponse<List<Downtime>> listMonitorDowntimesWithHttpInfo(Long monitorId) throws ApiException {
        Object localVarPostBody = null;
        if (monitorId == null) {
            throw new ApiException(400, "Missing the required parameter 'monitorId' when calling listMonitorDowntimes");
        }
        String localVarPath = "/api/v1/monitor/{monitor_id}/downtimes".replaceAll("\\{monitor_id\\}", this.apiClient.escapeString(monitorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listMonitorDowntimes");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<List<Downtime>> localVarReturnType = new GenericType<List<Downtime>>(){};
        return this.apiClient.invokeAPI("DowntimesApi.listMonitorDowntimes", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Downtime updateDowntime(Long downtimeId, Downtime body) throws ApiException {
        return this.updateDowntimeWithHttpInfo(downtimeId, body).getData();
    }

    public ApiResponse<Downtime> updateDowntimeWithHttpInfo(Long downtimeId, Downtime body) throws ApiException {
        Downtime localVarPostBody = body;
        if (downtimeId == null) {
            throw new ApiException(400, "Missing the required parameter 'downtimeId' when calling updateDowntime");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateDowntime");
        }
        String localVarPath = "/api/v1/downtime/{downtime_id}".replaceAll("\\{downtime_id\\}", this.apiClient.escapeString(downtimeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateDowntime");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<Downtime> localVarReturnType = new GenericType<Downtime>(){};
        return this.apiClient.invokeAPI("DowntimesApi.updateDowntime", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListDowntimesOptionalParameters {
        private Boolean currentOnly;

        public ListDowntimesOptionalParameters currentOnly(Boolean currentOnly) {
            this.currentOnly = currentOnly;
            return this;
        }
    }
}

