/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.MetricTagConfigurationMetricTypes;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing the definition of a metric tag configuration to be created.")
@JsonPropertyOrder(value={"include_percentiles", "metric_type", "tags"})
public class MetricTagConfigurationCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_INCLUDE_PERCENTILES = "include_percentiles";
    private Boolean includePercentiles = false;
    public static final String JSON_PROPERTY_METRIC_TYPE = "metric_type";
    private MetricTagConfigurationMetricTypes metricType = MetricTagConfigurationMetricTypes.GAUGE;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = new ArrayList<String>();

    public MetricTagConfigurationCreateAttributes() {
    }

    @JsonCreator
    public MetricTagConfigurationCreateAttributes(@JsonProperty(required=true, value="metric_type") MetricTagConfigurationMetricTypes metricType, @JsonProperty(required=true, value="tags") List<String> tags) {
        this.metricType = metricType;
        this.unparsed |= !metricType.isValid();
        this.tags = tags;
    }

    public MetricTagConfigurationCreateAttributes includePercentiles(Boolean includePercentiles) {
        this.includePercentiles = includePercentiles;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Toggle to include/exclude percentiles for a distribution metric. Defaults to false. Can only be applied to metrics that have a `metric_type` of `distribution`.")
    @JsonProperty(value="include_percentiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludePercentiles() {
        return this.includePercentiles;
    }

    public void setIncludePercentiles(Boolean includePercentiles) {
        this.includePercentiles = includePercentiles;
    }

    public MetricTagConfigurationCreateAttributes metricType(MetricTagConfigurationMetricTypes metricType) {
        this.metricType = metricType;
        this.unparsed |= !metricType.isValid();
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="metric_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MetricTagConfigurationMetricTypes getMetricType() {
        return this.metricType;
    }

    public void setMetricType(MetricTagConfigurationMetricTypes metricType) {
        if (!metricType.isValid()) {
            this.unparsed = true;
        }
        this.metricType = metricType;
    }

    public MetricTagConfigurationCreateAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricTagConfigurationCreateAttributes addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[\"app\",\"datacenter\"]", required=true, value="A list of tag keys that will be queryable for your metric.")
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricTagConfigurationCreateAttributes metricTagConfigurationCreateAttributes = (MetricTagConfigurationCreateAttributes)o;
        return Objects.equals(this.includePercentiles, metricTagConfigurationCreateAttributes.includePercentiles) && Objects.equals(this.metricType, metricTagConfigurationCreateAttributes.metricType) && Objects.equals(this.tags, metricTagConfigurationCreateAttributes.tags);
    }

    public int hashCode() {
        return Objects.hash(this.includePercentiles, this.metricType, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricTagConfigurationCreateAttributes {\n");
        sb.append("    includePercentiles: ").append(this.toIndentedString(this.includePercentiles)).append("\n");
        sb.append("    metricType: ").append(this.toIndentedString(this.metricType)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

