/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.UsageIncidentManagementHour;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response containing the incident management usage for each hour for a given organization.")
@JsonPropertyOrder(value={"usage"})
public class UsageIncidentManagementResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_USAGE = "usage";
    private List<UsageIncidentManagementHour> usage = null;

    public UsageIncidentManagementResponse usage(List<UsageIncidentManagementHour> usage) {
        this.usage = usage;
        for (UsageIncidentManagementHour item : usage) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public UsageIncidentManagementResponse addUsageItem(UsageIncidentManagementHour usageItem) {
        if (this.usage == null) {
            this.usage = new ArrayList<UsageIncidentManagementHour>();
        }
        this.usage.add(usageItem);
        this.unparsed |= usageItem.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Get hourly usage for incident management.")
    @JsonProperty(value="usage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UsageIncidentManagementHour> getUsage() {
        return this.usage;
    }

    public void setUsage(List<UsageIncidentManagementHour> usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageIncidentManagementResponse usageIncidentManagementResponse = (UsageIncidentManagementResponse)o;
        return Objects.equals(this.usage, usageIncidentManagementResponse.usage);
    }

    public int hashCode() {
        return Objects.hash(this.usage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageIncidentManagementResponse {\n");
        sb.append("    usage: ").append(this.toIndentedString(this.usage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

