/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.HostMeta;
import com.datadog.api.v1.client.model.HostMetrics;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object representing a host.")
@JsonPropertyOrder(value={"aliases", "apps", "aws_name", "host_name", "id", "is_muted", "last_reported_time", "meta", "metrics", "mute_timeout", "name", "sources", "tags_by_source", "up"})
public class Host {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALIASES = "aliases";
    private List<String> aliases = null;
    public static final String JSON_PROPERTY_APPS = "apps";
    private List<String> apps = null;
    public static final String JSON_PROPERTY_AWS_NAME = "aws_name";
    private String awsName;
    public static final String JSON_PROPERTY_HOST_NAME = "host_name";
    private String hostName;
    public static final String JSON_PROPERTY_ID = "id";
    private Long id;
    public static final String JSON_PROPERTY_IS_MUTED = "is_muted";
    private Boolean isMuted;
    public static final String JSON_PROPERTY_LAST_REPORTED_TIME = "last_reported_time";
    private Long lastReportedTime;
    public static final String JSON_PROPERTY_META = "meta";
    private HostMeta meta;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private HostMetrics metrics;
    public static final String JSON_PROPERTY_MUTE_TIMEOUT = "mute_timeout";
    private Long muteTimeout;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = null;
    public static final String JSON_PROPERTY_TAGS_BY_SOURCE = "tags_by_source";
    private Map<String, List<String>> tagsBySource = null;
    public static final String JSON_PROPERTY_UP = "up";
    private Boolean up;

    public Host aliases(List<String> aliases) {
        this.aliases = aliases;
        return this;
    }

    public Host addAliasesItem(String aliasesItem) {
        if (this.aliases == null) {
            this.aliases = new ArrayList<String>();
        }
        this.aliases.add(aliasesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host aliases collected by Datadog.")
    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAliases() {
        return this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public Host apps(List<String> apps) {
        this.apps = apps;
        return this;
    }

    public Host addAppsItem(String appsItem) {
        if (this.apps == null) {
            this.apps = new ArrayList<String>();
        }
        this.apps.add(appsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Datadog integrations reporting metrics for the host.")
    @JsonProperty(value="apps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getApps() {
        return this.apps;
    }

    public void setApps(List<String> apps) {
        this.apps = apps;
    }

    public Host awsName(String awsName) {
        this.awsName = awsName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mycoolhost-1", value="AWS name of your host.")
    @JsonProperty(value="aws_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAwsName() {
        return this.awsName;
    }

    public void setAwsName(String awsName) {
        this.awsName = awsName;
    }

    public Host hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="i-deadbeef", value="The host name.")
    @JsonProperty(value="host_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Host id(Long id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123456", value="The host ID.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Host isMuted(Boolean isMuted) {
        this.isMuted = isMuted;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="If a host is muted or unmuted.")
    @JsonProperty(value="is_muted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsMuted() {
        return this.isMuted;
    }

    public void setIsMuted(Boolean isMuted) {
        this.isMuted = isMuted;
    }

    public Host lastReportedTime(Long lastReportedTime) {
        this.lastReportedTime = lastReportedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1565000000", value="Last time the host reported a metric data point.")
    @JsonProperty(value="last_reported_time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLastReportedTime() {
        return this.lastReportedTime;
    }

    public void setLastReportedTime(Long lastReportedTime) {
        this.lastReportedTime = lastReportedTime;
    }

    public Host meta(HostMeta meta) {
        this.meta = meta;
        this.unparsed |= meta.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HostMeta getMeta() {
        return this.meta;
    }

    public void setMeta(HostMeta meta) {
        this.meta = meta;
    }

    public Host metrics(HostMetrics metrics) {
        this.metrics = metrics;
        this.unparsed |= metrics.unparsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HostMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(HostMetrics metrics) {
        this.metrics = metrics;
    }

    public Host muteTimeout(Long muteTimeout) {
        this.muteTimeout = muteTimeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timeout of the mute applied to your host.")
    @JsonProperty(value="mute_timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMuteTimeout() {
        return this.muteTimeout;
    }

    public void setMuteTimeout(Long muteTimeout) {
        this.muteTimeout = muteTimeout;
    }

    public Host name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="i-hostname", value="The host name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Host sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public Host addSourcesItem(String sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Source or cloud provider associated with your host.")
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public Host tagsBySource(Map<String, List<String>> tagsBySource) {
        this.tagsBySource = tagsBySource;
        return this;
    }

    public Host putTagsBySourceItem(String key, List<String> tagsBySourceItem) {
        if (this.tagsBySource == null) {
            this.tagsBySource = new HashMap<String, List<String>>();
        }
        this.tagsBySource.put(key, tagsBySourceItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of tags for each source (AWS, Datadog Agent, Chef..).")
    @JsonProperty(value="tags_by_source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, List<String>> getTagsBySource() {
        return this.tagsBySource;
    }

    public void setTagsBySource(Map<String, List<String>> tagsBySource) {
        this.tagsBySource = tagsBySource;
    }

    public Host up(Boolean up) {
        this.up = up;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Displays UP when the expected metrics are received and displays `???` if no metrics are received.")
    @JsonProperty(value="up")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUp() {
        return this.up;
    }

    public void setUp(Boolean up) {
        this.up = up;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host host = (Host)o;
        return Objects.equals(this.aliases, host.aliases) && Objects.equals(this.apps, host.apps) && Objects.equals(this.awsName, host.awsName) && Objects.equals(this.hostName, host.hostName) && Objects.equals(this.id, host.id) && Objects.equals(this.isMuted, host.isMuted) && Objects.equals(this.lastReportedTime, host.lastReportedTime) && Objects.equals(this.meta, host.meta) && Objects.equals(this.metrics, host.metrics) && Objects.equals(this.muteTimeout, host.muteTimeout) && Objects.equals(this.name, host.name) && Objects.equals(this.sources, host.sources) && Objects.equals(this.tagsBySource, host.tagsBySource) && Objects.equals(this.up, host.up);
    }

    public int hashCode() {
        return Objects.hash(this.aliases, this.apps, this.awsName, this.hostName, this.id, this.isMuted, this.lastReportedTime, this.meta, this.metrics, this.muteTimeout, this.name, this.sources, this.tagsBySource, this.up);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Host {\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    apps: ").append(this.toIndentedString(this.apps)).append("\n");
        sb.append("    awsName: ").append(this.toIndentedString(this.awsName)).append("\n");
        sb.append("    hostName: ").append(this.toIndentedString(this.hostName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isMuted: ").append(this.toIndentedString(this.isMuted)).append("\n");
        sb.append("    lastReportedTime: ").append(this.toIndentedString(this.lastReportedTime)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    muteTimeout: ").append(this.toIndentedString(this.muteTimeout)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    tagsBySource: ").append(this.toIndentedString(this.tagsBySource)).append("\n");
        sb.append("    up: ").append(this.toIndentedString(this.up)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

