/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Your Google Cloud Platform Account.")
@JsonPropertyOrder(value={"auth_provider_x509_cert_url", "auth_uri", "automute", "client_email", "client_id", "client_x509_cert_url", "errors", "host_filters", "private_key", "private_key_id", "project_id", "token_uri", "type"})
public class GCPAccount {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTH_PROVIDER_X509_CERT_URL = "auth_provider_x509_cert_url";
    private String authProviderX509CertUrl;
    public static final String JSON_PROPERTY_AUTH_URI = "auth_uri";
    private String authUri;
    public static final String JSON_PROPERTY_AUTOMUTE = "automute";
    private Boolean automute;
    public static final String JSON_PROPERTY_CLIENT_EMAIL = "client_email";
    private String clientEmail;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_X509_CERT_URL = "client_x509_cert_url";
    private String clientX509CertUrl;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<String> errors = null;
    public static final String JSON_PROPERTY_HOST_FILTERS = "host_filters";
    private String hostFilters;
    public static final String JSON_PROPERTY_PRIVATE_KEY = "private_key";
    private String privateKey;
    public static final String JSON_PROPERTY_PRIVATE_KEY_ID = "private_key_id";
    private String privateKeyId;
    public static final String JSON_PROPERTY_PROJECT_ID = "project_id";
    private String projectId;
    public static final String JSON_PROPERTY_TOKEN_URI = "token_uri";
    private String tokenUri;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public GCPAccount authProviderX509CertUrl(String authProviderX509CertUrl) {
        this.authProviderX509CertUrl = authProviderX509CertUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.googleapis.com/oauth2/v1/certs", value="Should be `https://www.googleapis.com/oauth2/v1/certs`.")
    @JsonProperty(value="auth_provider_x509_cert_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthProviderX509CertUrl() {
        return this.authProviderX509CertUrl;
    }

    public void setAuthProviderX509CertUrl(String authProviderX509CertUrl) {
        this.authProviderX509CertUrl = authProviderX509CertUrl;
    }

    public GCPAccount authUri(String authUri) {
        this.authUri = authUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://accounts.google.com/o/oauth2/auth", value="Should be `https://accounts.google.com/o/oauth2/auth`.")
    @JsonProperty(value="auth_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthUri() {
        return this.authUri;
    }

    public void setAuthUri(String authUri) {
        this.authUri = authUri;
    }

    public GCPAccount automute(Boolean automute) {
        this.automute = automute;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Silence monitors for expected GCE instance shutdowns.")
    @JsonProperty(value="automute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutomute() {
        return this.automute;
    }

    public void setAutomute(Boolean automute) {
        this.automute = automute;
    }

    public GCPAccount clientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="api-dev@datadog-sandbox.iam.gserviceaccount.com", value="Your email found in your JSON service account key.")
    @JsonProperty(value="client_email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientEmail() {
        return this.clientEmail;
    }

    public void setClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public GCPAccount clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123456712345671234567", value="Your ID found in your JSON service account key.")
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public GCPAccount clientX509CertUrl(String clientX509CertUrl) {
        this.clientX509CertUrl = clientX509CertUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://www.googleapis.com/robot/v1/metadata/x509/<CLIENT_EMAIL>", value="Should be `https://www.googleapis.com/robot/v1/metadata/x509/<CLIENT_EMAIL>` where `<CLIENT_EMAIL>` is the email found in your JSON service account key.")
    @JsonProperty(value="client_x509_cert_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientX509CertUrl() {
        return this.clientX509CertUrl;
    }

    public void setClientX509CertUrl(String clientX509CertUrl) {
        this.clientX509CertUrl = clientX509CertUrl;
    }

    public GCPAccount errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public GCPAccount addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"*\"]", value="An array of errors.")
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public GCPAccount hostFilters(String hostFilters) {
        this.hostFilters = hostFilters;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="key:value,filter:example", value="Limit the GCE instances that are pulled into Datadog by using tags. Only hosts that match one of the defined tags are imported into Datadog.")
    @JsonProperty(value="host_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostFilters() {
        return this.hostFilters;
    }

    public void setHostFilters(String hostFilters) {
        this.hostFilters = hostFilters;
    }

    public GCPAccount privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="private_key", value="Your private key name found in your JSON service account key.")
    @JsonProperty(value="private_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public GCPAccount privateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123456789abcdefghi123456789abcdefghijklm", value="Your private key ID found in your JSON service account key.")
    @JsonProperty(value="private_key_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public void setPrivateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    public GCPAccount projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="datadog-apitest", value="Your Google Cloud project ID found in your JSON service account key.")
    @JsonProperty(value="project_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public GCPAccount tokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://accounts.google.com/o/oauth2/token", value="Should be `https://accounts.google.com/o/oauth2/token`.")
    @JsonProperty(value="token_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenUri() {
        return this.tokenUri;
    }

    public void setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
    }

    public GCPAccount type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="service_account", value="The value for service_account found in your JSON service account key.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GCPAccount gcPAccount = (GCPAccount)o;
        return Objects.equals(this.authProviderX509CertUrl, gcPAccount.authProviderX509CertUrl) && Objects.equals(this.authUri, gcPAccount.authUri) && Objects.equals(this.automute, gcPAccount.automute) && Objects.equals(this.clientEmail, gcPAccount.clientEmail) && Objects.equals(this.clientId, gcPAccount.clientId) && Objects.equals(this.clientX509CertUrl, gcPAccount.clientX509CertUrl) && Objects.equals(this.errors, gcPAccount.errors) && Objects.equals(this.hostFilters, gcPAccount.hostFilters) && Objects.equals(this.privateKey, gcPAccount.privateKey) && Objects.equals(this.privateKeyId, gcPAccount.privateKeyId) && Objects.equals(this.projectId, gcPAccount.projectId) && Objects.equals(this.tokenUri, gcPAccount.tokenUri) && Objects.equals(this.type, gcPAccount.type);
    }

    public int hashCode() {
        return Objects.hash(this.authProviderX509CertUrl, this.authUri, this.automute, this.clientEmail, this.clientId, this.clientX509CertUrl, this.errors, this.hostFilters, this.privateKey, this.privateKeyId, this.projectId, this.tokenUri, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GCPAccount {\n");
        sb.append("    authProviderX509CertUrl: ").append(this.toIndentedString(this.authProviderX509CertUrl)).append("\n");
        sb.append("    authUri: ").append(this.toIndentedString(this.authUri)).append("\n");
        sb.append("    automute: ").append(this.toIndentedString(this.automute)).append("\n");
        sb.append("    clientEmail: ").append(this.toIndentedString(this.clientEmail)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientX509CertUrl: ").append(this.toIndentedString(this.clientX509CertUrl)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    hostFilters: ").append(this.toIndentedString(this.hostFilters)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    privateKeyId: ").append(this.toIndentedString(this.privateKeyId)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    tokenUri: ").append(this.toIndentedString(this.tokenUri)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

