/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.SyntheticsAPITest;
import com.datadog.api.v1.client.model.SyntheticsAPITestResultFull;
import com.datadog.api.v1.client.model.SyntheticsBrowserTest;
import com.datadog.api.v1.client.model.SyntheticsBrowserTestResultFull;
import com.datadog.api.v1.client.model.SyntheticsCITestBody;
import com.datadog.api.v1.client.model.SyntheticsDeleteTestsPayload;
import com.datadog.api.v1.client.model.SyntheticsDeleteTestsResponse;
import com.datadog.api.v1.client.model.SyntheticsGetAPITestLatestResultsResponse;
import com.datadog.api.v1.client.model.SyntheticsGetBrowserTestLatestResultsResponse;
import com.datadog.api.v1.client.model.SyntheticsGlobalVariable;
import com.datadog.api.v1.client.model.SyntheticsListGlobalVariablesResponse;
import com.datadog.api.v1.client.model.SyntheticsListTestsResponse;
import com.datadog.api.v1.client.model.SyntheticsLocations;
import com.datadog.api.v1.client.model.SyntheticsPrivateLocation;
import com.datadog.api.v1.client.model.SyntheticsPrivateLocationCreationResponse;
import com.datadog.api.v1.client.model.SyntheticsTestDetails;
import com.datadog.api.v1.client.model.SyntheticsTriggerCITestsResponse;
import com.datadog.api.v1.client.model.SyntheticsUpdateTestPauseStatusPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class SyntheticsApi {
    private ApiClient apiClient;

    public SyntheticsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SyntheticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SyntheticsGlobalVariable createGlobalVariable(SyntheticsGlobalVariable body) throws ApiException {
        return this.createGlobalVariableWithHttpInfo(body).getData();
    }

    public ApiResponse<SyntheticsGlobalVariable> createGlobalVariableWithHttpInfo(SyntheticsGlobalVariable body) throws ApiException {
        SyntheticsGlobalVariable localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createGlobalVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGlobalVariable> localVarReturnType = new GenericType<SyntheticsGlobalVariable>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.createGlobalVariable", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsPrivateLocationCreationResponse createPrivateLocation(SyntheticsPrivateLocation body) throws ApiException {
        return this.createPrivateLocationWithHttpInfo(body).getData();
    }

    public ApiResponse<SyntheticsPrivateLocationCreationResponse> createPrivateLocationWithHttpInfo(SyntheticsPrivateLocation body) throws ApiException {
        SyntheticsPrivateLocation localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createPrivateLocation");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsPrivateLocationCreationResponse> localVarReturnType = new GenericType<SyntheticsPrivateLocationCreationResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.createPrivateLocation", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsAPITest createSyntheticsAPITest(SyntheticsAPITest body) throws ApiException {
        return this.createSyntheticsAPITestWithHttpInfo(body).getData();
    }

    public ApiResponse<SyntheticsAPITest> createSyntheticsAPITestWithHttpInfo(SyntheticsAPITest body) throws ApiException {
        SyntheticsAPITest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSyntheticsAPITest");
        }
        String localVarPath = "/api/v1/synthetics/tests/api";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createSyntheticsAPITest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsAPITest> localVarReturnType = new GenericType<SyntheticsAPITest>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.createSyntheticsAPITest", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsBrowserTest createSyntheticsBrowserTest(SyntheticsBrowserTest body) throws ApiException {
        return this.createSyntheticsBrowserTestWithHttpInfo(body).getData();
    }

    public ApiResponse<SyntheticsBrowserTest> createSyntheticsBrowserTestWithHttpInfo(SyntheticsBrowserTest body) throws ApiException {
        SyntheticsBrowserTest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSyntheticsBrowserTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createSyntheticsBrowserTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsBrowserTest> localVarReturnType = new GenericType<SyntheticsBrowserTest>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.createSyntheticsBrowserTest", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteGlobalVariable(String variableId) throws ApiException {
        this.deleteGlobalVariableWithHttpInfo(variableId);
    }

    public ApiResponse<Void> deleteGlobalVariableWithHttpInfo(String variableId) throws ApiException {
        Object localVarPostBody = null;
        if (variableId == null) {
            throw new ApiException(400, "Missing the required parameter 'variableId' when calling deleteGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteGlobalVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("SyntheticsApi.deleteGlobalVariable", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public void deletePrivateLocation(String locationId) throws ApiException {
        this.deletePrivateLocationWithHttpInfo(locationId);
    }

    public ApiResponse<Void> deletePrivateLocationWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deletePrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deletePrivateLocation");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("SyntheticsApi.deletePrivateLocation", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public SyntheticsDeleteTestsResponse deleteTests(SyntheticsDeleteTestsPayload body) throws ApiException {
        return this.deleteTestsWithHttpInfo(body).getData();
    }

    public ApiResponse<SyntheticsDeleteTestsResponse> deleteTestsWithHttpInfo(SyntheticsDeleteTestsPayload body) throws ApiException {
        SyntheticsDeleteTestsPayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteTests");
        }
        String localVarPath = "/api/v1/synthetics/tests/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteTests");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsDeleteTestsResponse> localVarReturnType = new GenericType<SyntheticsDeleteTestsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.deleteTests", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsGlobalVariable editGlobalVariable(String variableId, SyntheticsGlobalVariable body) throws ApiException {
        return this.editGlobalVariableWithHttpInfo(variableId, body).getData();
    }

    public ApiResponse<SyntheticsGlobalVariable> editGlobalVariableWithHttpInfo(String variableId, SyntheticsGlobalVariable body) throws ApiException {
        SyntheticsGlobalVariable localVarPostBody = body;
        if (variableId == null) {
            throw new ApiException(400, "Missing the required parameter 'variableId' when calling editGlobalVariable");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "editGlobalVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGlobalVariable> localVarReturnType = new GenericType<SyntheticsGlobalVariable>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.editGlobalVariable", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsAPITest getAPITest(String publicId) throws ApiException {
        return this.getAPITestWithHttpInfo(publicId).getData();
    }

    public ApiResponse<SyntheticsAPITest> getAPITestWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITest");
        }
        String localVarPath = "/api/v1/synthetics/tests/api/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPITest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsAPITest> localVarReturnType = new GenericType<SyntheticsAPITest>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getAPITest", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsGetAPITestLatestResultsResponse getAPITestLatestResults(String publicId) throws ApiException {
        return this.getAPITestLatestResultsWithHttpInfo(publicId, new GetAPITestLatestResultsOptionalParameters()).getData();
    }

    public SyntheticsGetAPITestLatestResultsResponse getAPITestLatestResults(String publicId, GetAPITestLatestResultsOptionalParameters parameters) throws ApiException {
        return this.getAPITestLatestResultsWithHttpInfo(publicId, parameters).getData();
    }

    public ApiResponse<SyntheticsGetAPITestLatestResultsResponse> getAPITestLatestResultsWithHttpInfo(String publicId, GetAPITestLatestResultsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITestLatestResults");
        }
        Long fromTs = parameters.fromTs;
        Long toTs = parameters.toTs;
        List probeDc = parameters.probeDc;
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/results".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "probe_dc", probeDc));
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPITestLatestResults");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGetAPITestLatestResultsResponse> localVarReturnType = new GenericType<SyntheticsGetAPITestLatestResultsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getAPITestLatestResults", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsAPITestResultFull getAPITestResult(String publicId, String resultId) throws ApiException {
        return this.getAPITestResultWithHttpInfo(publicId, resultId).getData();
    }

    public ApiResponse<SyntheticsAPITestResultFull> getAPITestResultWithHttpInfo(String publicId, String resultId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITestResult");
        }
        if (resultId == null) {
            throw new ApiException(400, "Missing the required parameter 'resultId' when calling getAPITestResult");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/results/{result_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString())).replaceAll("\\{result_id\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPITestResult");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsAPITestResultFull> localVarReturnType = new GenericType<SyntheticsAPITestResultFull>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getAPITestResult", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsBrowserTest getBrowserTest(String publicId) throws ApiException {
        return this.getBrowserTestWithHttpInfo(publicId).getData();
    }

    public ApiResponse<SyntheticsBrowserTest> getBrowserTestWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getBrowserTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsBrowserTest> localVarReturnType = new GenericType<SyntheticsBrowserTest>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getBrowserTest", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsGetBrowserTestLatestResultsResponse getBrowserTestLatestResults(String publicId) throws ApiException {
        return this.getBrowserTestLatestResultsWithHttpInfo(publicId, new GetBrowserTestLatestResultsOptionalParameters()).getData();
    }

    public SyntheticsGetBrowserTestLatestResultsResponse getBrowserTestLatestResults(String publicId, GetBrowserTestLatestResultsOptionalParameters parameters) throws ApiException {
        return this.getBrowserTestLatestResultsWithHttpInfo(publicId, parameters).getData();
    }

    public ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse> getBrowserTestLatestResultsWithHttpInfo(String publicId, GetBrowserTestLatestResultsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTestLatestResults");
        }
        Long fromTs = parameters.fromTs;
        Long toTs = parameters.toTs;
        List probeDc = parameters.probeDc;
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}/results".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "probe_dc", probeDc));
        localVarHeaderParams.put("DD-OPERATION-ID", "getBrowserTestLatestResults");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGetBrowserTestLatestResultsResponse> localVarReturnType = new GenericType<SyntheticsGetBrowserTestLatestResultsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getBrowserTestLatestResults", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsBrowserTestResultFull getBrowserTestResult(String publicId, String resultId) throws ApiException {
        return this.getBrowserTestResultWithHttpInfo(publicId, resultId).getData();
    }

    public ApiResponse<SyntheticsBrowserTestResultFull> getBrowserTestResultWithHttpInfo(String publicId, String resultId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTestResult");
        }
        if (resultId == null) {
            throw new ApiException(400, "Missing the required parameter 'resultId' when calling getBrowserTestResult");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}/results/{result_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString())).replaceAll("\\{result_id\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getBrowserTestResult");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsBrowserTestResultFull> localVarReturnType = new GenericType<SyntheticsBrowserTestResultFull>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getBrowserTestResult", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsGlobalVariable getGlobalVariable(String variableId) throws ApiException {
        return this.getGlobalVariableWithHttpInfo(variableId).getData();
    }

    public ApiResponse<SyntheticsGlobalVariable> getGlobalVariableWithHttpInfo(String variableId) throws ApiException {
        Object localVarPostBody = null;
        if (variableId == null) {
            throw new ApiException(400, "Missing the required parameter 'variableId' when calling getGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getGlobalVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGlobalVariable> localVarReturnType = new GenericType<SyntheticsGlobalVariable>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getGlobalVariable", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsPrivateLocation getPrivateLocation(String locationId) throws ApiException {
        return this.getPrivateLocationWithHttpInfo(locationId).getData();
    }

    public ApiResponse<SyntheticsPrivateLocation> getPrivateLocationWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling getPrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getPrivateLocation");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsPrivateLocation> localVarReturnType = new GenericType<SyntheticsPrivateLocation>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getPrivateLocation", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsTestDetails getTest(String publicId) throws ApiException {
        return this.getTestWithHttpInfo(publicId).getData();
    }

    public ApiResponse<SyntheticsTestDetails> getTestWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTestDetails> localVarReturnType = new GenericType<SyntheticsTestDetails>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getTest", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsListGlobalVariablesResponse listGlobalVariables() throws ApiException {
        return this.listGlobalVariablesWithHttpInfo().getData();
    }

    public ApiResponse<SyntheticsListGlobalVariablesResponse> listGlobalVariablesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/variables";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listGlobalVariables");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsListGlobalVariablesResponse> localVarReturnType = new GenericType<SyntheticsListGlobalVariablesResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.listGlobalVariables", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsLocations listLocations() throws ApiException {
        return this.listLocationsWithHttpInfo().getData();
    }

    public ApiResponse<SyntheticsLocations> listLocationsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/locations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLocations");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsLocations> localVarReturnType = new GenericType<SyntheticsLocations>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.listLocations", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsListTestsResponse listTests() throws ApiException {
        return this.listTestsWithHttpInfo().getData();
    }

    public ApiResponse<SyntheticsListTestsResponse> listTestsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/tests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listTests");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsListTestsResponse> localVarReturnType = new GenericType<SyntheticsListTestsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.listTests", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsTriggerCITestsResponse triggerCITests(SyntheticsCITestBody body) throws ApiException {
        return this.triggerCITestsWithHttpInfo(body).getData();
    }

    public ApiResponse<SyntheticsTriggerCITestsResponse> triggerCITestsWithHttpInfo(SyntheticsCITestBody body) throws ApiException {
        SyntheticsCITestBody localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling triggerCITests");
        }
        String localVarPath = "/api/v1/synthetics/tests/trigger/ci";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "triggerCITests");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTriggerCITestsResponse> localVarReturnType = new GenericType<SyntheticsTriggerCITestsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.triggerCITests", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsAPITest updateAPITest(String publicId, SyntheticsAPITest body) throws ApiException {
        return this.updateAPITestWithHttpInfo(publicId, body).getData();
    }

    public ApiResponse<SyntheticsAPITest> updateAPITestWithHttpInfo(String publicId, SyntheticsAPITest body) throws ApiException {
        SyntheticsAPITest localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateAPITest");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAPITest");
        }
        String localVarPath = "/api/v1/synthetics/tests/api/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateAPITest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsAPITest> localVarReturnType = new GenericType<SyntheticsAPITest>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.updateAPITest", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsBrowserTest updateBrowserTest(String publicId, SyntheticsBrowserTest body) throws ApiException {
        return this.updateBrowserTestWithHttpInfo(publicId, body).getData();
    }

    public ApiResponse<SyntheticsBrowserTest> updateBrowserTestWithHttpInfo(String publicId, SyntheticsBrowserTest body) throws ApiException {
        SyntheticsBrowserTest localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateBrowserTest");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateBrowserTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateBrowserTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsBrowserTest> localVarReturnType = new GenericType<SyntheticsBrowserTest>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.updateBrowserTest", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public SyntheticsPrivateLocation updatePrivateLocation(String locationId, SyntheticsPrivateLocation body) throws ApiException {
        return this.updatePrivateLocationWithHttpInfo(locationId, body).getData();
    }

    public ApiResponse<SyntheticsPrivateLocation> updatePrivateLocationWithHttpInfo(String locationId, SyntheticsPrivateLocation body) throws ApiException {
        SyntheticsPrivateLocation localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updatePrivateLocation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updatePrivateLocation");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsPrivateLocation> localVarReturnType = new GenericType<SyntheticsPrivateLocation>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.updatePrivateLocation", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Boolean updateTestPauseStatus(String publicId, SyntheticsUpdateTestPauseStatusPayload body) throws ApiException {
        return this.updateTestPauseStatusWithHttpInfo(publicId, body).getData();
    }

    public ApiResponse<Boolean> updateTestPauseStatusWithHttpInfo(String publicId, SyntheticsUpdateTestPauseStatusPayload body) throws ApiException {
        SyntheticsUpdateTestPauseStatusPayload localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateTestPauseStatus");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTestPauseStatus");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/status".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateTestPauseStatus");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"};
        GenericType<Boolean> localVarReturnType = new GenericType<Boolean>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.updateTestPauseStatus", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class GetBrowserTestLatestResultsOptionalParameters {
        private Long fromTs;
        private Long toTs;
        private List<String> probeDc;

        public GetBrowserTestLatestResultsOptionalParameters fromTs(Long fromTs) {
            this.fromTs = fromTs;
            return this;
        }

        public GetBrowserTestLatestResultsOptionalParameters toTs(Long toTs) {
            this.toTs = toTs;
            return this;
        }

        public GetBrowserTestLatestResultsOptionalParameters probeDc(List<String> probeDc) {
            this.probeDc = probeDc;
            return this;
        }
    }

    public static class GetAPITestLatestResultsOptionalParameters {
        private Long fromTs;
        private Long toTs;
        private List<String> probeDc;

        public GetAPITestLatestResultsOptionalParameters fromTs(Long fromTs) {
            this.fromTs = fromTs;
            return this;
        }

        public GetAPITestLatestResultsOptionalParameters toTs(Long toTs) {
            this.toTs = toTs;
            return this;
        }

        public GetAPITestLatestResultsOptionalParameters probeDc(List<String> probeDc) {
            this.probeDc = probeDc;
            return this;
        }
    }
}

