/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentServicesResponseMeta;
import com.datadog.api.v2.client.model.IncidentTeamIncludedItems;
import com.datadog.api.v2.client.model.IncidentTeamResponseData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response with a list of incident team payloads.")
@JsonPropertyOrder(value={"data", "included", "meta"})
public class IncidentTeamsResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<IncidentTeamResponseData> data = new ArrayList<IncidentTeamResponseData>();
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<IncidentTeamIncludedItems> included = null;
    public static final String JSON_PROPERTY_META = "meta";
    private IncidentServicesResponseMeta meta;

    public IncidentTeamsResponse() {
    }

    @JsonCreator
    public IncidentTeamsResponse(@JsonProperty(required=true, value="data") List<IncidentTeamResponseData> data) {
        this.data = data;
    }

    public IncidentTeamsResponse data(List<IncidentTeamResponseData> data) {
        this.data = data;
        return this;
    }

    public IncidentTeamsResponse addDataItem(IncidentTeamResponseData dataItem) {
        this.data.add(dataItem);
        return this;
    }

    @ApiModelProperty(example="[{\"attributes\":{\"name\":\"team name\"},\"id\":\"00000000-0000-0000-0000-000000000000\",\"type\":\"teams\"}]", required=true, value="An array of incident teams.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IncidentTeamResponseData> getData() {
        return this.data;
    }

    public void setData(List<IncidentTeamResponseData> data) {
        this.data = data;
    }

    @Nullable
    @ApiModelProperty(value="Included related resources which the user requested.")
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IncidentTeamIncludedItems> getIncluded() {
        return this.included;
    }

    public IncidentTeamsResponse meta(IncidentServicesResponseMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentServicesResponseMeta getMeta() {
        return this.meta;
    }

    public void setMeta(IncidentServicesResponseMeta meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentTeamsResponse incidentTeamsResponse = (IncidentTeamsResponse)o;
        return Objects.equals(this.data, incidentTeamsResponse.data) && Objects.equals(this.included, incidentTeamsResponse.included) && Objects.equals(this.meta, incidentTeamsResponse.meta);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentTeamsResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

