/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Cloud Workload Security usage for a given organization for a given hour.")
@JsonPropertyOrder(value={"cws_container_count", "cws_host_count", "hour"})
public class UsageCWSHour {
    public static final String JSON_PROPERTY_CWS_CONTAINER_COUNT = "cws_container_count";
    private Long cwsContainerCount;
    public static final String JSON_PROPERTY_CWS_HOST_COUNT = "cws_host_count";
    private Long cwsHostCount;
    public static final String JSON_PROPERTY_HOUR = "hour";
    private OffsetDateTime hour;

    public UsageCWSHour cwsContainerCount(Long cwsContainerCount) {
        this.cwsContainerCount = cwsContainerCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of Cloud Workload Security container hours from the start of the given hour\u2019s month until the given hour.")
    @JsonProperty(value="cws_container_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCwsContainerCount() {
        return this.cwsContainerCount;
    }

    public void setCwsContainerCount(Long cwsContainerCount) {
        this.cwsContainerCount = cwsContainerCount;
    }

    public UsageCWSHour cwsHostCount(Long cwsHostCount) {
        this.cwsHostCount = cwsHostCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total number of Cloud Workload Security host hours from the start of the given hour\u2019s month until the given hour.")
    @JsonProperty(value="cws_host_count")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCwsHostCount() {
        return this.cwsHostCount;
    }

    public void setCwsHostCount(Long cwsHostCount) {
        this.cwsHostCount = cwsHostCount;
    }

    public UsageCWSHour hour(OffsetDateTime hour) {
        this.hour = hour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hour for the usage.")
    @JsonProperty(value="hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getHour() {
        return this.hour;
    }

    public void setHour(OffsetDateTime hour) {
        this.hour = hour;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageCWSHour usageCWSHour = (UsageCWSHour)o;
        return Objects.equals(this.cwsContainerCount, usageCWSHour.cwsContainerCount) && Objects.equals(this.cwsHostCount, usageCWSHour.cwsHostCount) && Objects.equals(this.hour, usageCWSHour.hour);
    }

    public int hashCode() {
        return Objects.hash(this.cwsContainerCount, this.cwsHostCount, this.hour);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageCWSHour {\n");
        sb.append("    cwsContainerCount: ").append(this.toIndentedString(this.cwsContainerCount)).append("\n");
        sb.append("    cwsHostCount: ").append(this.toIndentedString(this.cwsHostCount)).append("\n");
        sb.append("    hour: ").append(this.toIndentedString(this.hour)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

