/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.TreeMapColorBy;
import com.datadog.api.v1.client.model.TreeMapGroupBy;
import com.datadog.api.v1.client.model.TreeMapSizeBy;
import com.datadog.api.v1.client.model.TreeMapWidgetDefinitionType;
import com.datadog.api.v1.client.model.TreeMapWidgetRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The treemap visualization found on the Host Dashboards comes from the output of `ps auxww`. This is not continuously run on your hosts. Instead, it\u2019s run once on Agent start/restart. The treemap is only supported for process data on a single host dashboard \u2014 this may not be reused in other dashboards or for other metrics.")
@JsonPropertyOrder(value={"color_by", "group_by", "requests", "size_by", "title", "type"})
public class TreeMapWidgetDefinition {
    public static final String JSON_PROPERTY_COLOR_BY = "color_by";
    private TreeMapColorBy colorBy = TreeMapColorBy.USER;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private TreeMapGroupBy groupBy;
    public static final String JSON_PROPERTY_REQUESTS = "requests";
    private List<TreeMapWidgetRequest> requests = new ArrayList<TreeMapWidgetRequest>();
    public static final String JSON_PROPERTY_SIZE_BY = "size_by";
    private TreeMapSizeBy sizeBy;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TreeMapWidgetDefinitionType type = TreeMapWidgetDefinitionType.TREEMAP;

    public TreeMapWidgetDefinition() {
    }

    @JsonCreator
    public TreeMapWidgetDefinition(@JsonProperty(required=true, value="color_by") TreeMapColorBy colorBy, @JsonProperty(required=true, value="group_by") TreeMapGroupBy groupBy, @JsonProperty(required=true, value="requests") List<TreeMapWidgetRequest> requests, @JsonProperty(required=true, value="size_by") TreeMapSizeBy sizeBy, @JsonProperty(required=true, value="type") TreeMapWidgetDefinitionType type) {
        this.colorBy = colorBy;
        this.groupBy = groupBy;
        this.requests = requests;
        this.sizeBy = sizeBy;
        this.type = type;
    }

    public TreeMapWidgetDefinition colorBy(TreeMapColorBy colorBy) {
        this.colorBy = colorBy;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="color_by")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TreeMapColorBy getColorBy() {
        return this.colorBy;
    }

    public void setColorBy(TreeMapColorBy colorBy) {
        this.colorBy = colorBy;
    }

    public TreeMapWidgetDefinition groupBy(TreeMapGroupBy groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TreeMapGroupBy getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(TreeMapGroupBy groupBy) {
        this.groupBy = groupBy;
    }

    public TreeMapWidgetDefinition requests(List<TreeMapWidgetRequest> requests) {
        this.requests = requests;
        return this;
    }

    public TreeMapWidgetDefinition addRequestsItem(TreeMapWidgetRequest requestsItem) {
        this.requests.add(requestsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"q\":\"system.load.1\"}]", required=true, value="List of top list widget requests.")
    @JsonProperty(value="requests")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TreeMapWidgetRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<TreeMapWidgetRequest> requests) {
        this.requests = requests;
    }

    public TreeMapWidgetDefinition sizeBy(TreeMapSizeBy sizeBy) {
        this.sizeBy = sizeBy;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="size_by")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TreeMapSizeBy getSizeBy() {
        return this.sizeBy;
    }

    public void setSizeBy(TreeMapSizeBy sizeBy) {
        this.sizeBy = sizeBy;
    }

    public TreeMapWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of your widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public TreeMapWidgetDefinition type(TreeMapWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TreeMapWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(TreeMapWidgetDefinitionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeMapWidgetDefinition treeMapWidgetDefinition = (TreeMapWidgetDefinition)o;
        return Objects.equals((Object)this.colorBy, (Object)treeMapWidgetDefinition.colorBy) && Objects.equals((Object)this.groupBy, (Object)treeMapWidgetDefinition.groupBy) && Objects.equals(this.requests, treeMapWidgetDefinition.requests) && Objects.equals((Object)this.sizeBy, (Object)treeMapWidgetDefinition.sizeBy) && Objects.equals(this.title, treeMapWidgetDefinition.title) && Objects.equals((Object)this.type, (Object)treeMapWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.colorBy, this.groupBy, this.requests, this.sizeBy, this.title, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TreeMapWidgetDefinition {\n");
        sb.append("    colorBy: ").append(this.toIndentedString((Object)this.colorBy)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString((Object)this.groupBy)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    sizeBy: ").append(this.toIndentedString((Object)this.sizeBy)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

