/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SyntheticsAPIStep;
import com.datadog.api.v1.client.model.SyntheticsAssertion;
import com.datadog.api.v1.client.model.SyntheticsConfigVariable;
import com.datadog.api.v1.client.model.SyntheticsTestRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configuration object for a Synthetic API test.")
@JsonPropertyOrder(value={"assertions", "configVariables", "request", "steps"})
public class SyntheticsAPITestConfig {
    public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
    private List<SyntheticsAssertion> assertions = null;
    public static final String JSON_PROPERTY_CONFIG_VARIABLES = "configVariables";
    private List<SyntheticsConfigVariable> configVariables = null;
    public static final String JSON_PROPERTY_REQUEST = "request";
    private SyntheticsTestRequest request;
    public static final String JSON_PROPERTY_STEPS = "steps";
    private List<SyntheticsAPIStep> steps = null;

    public SyntheticsAPITestConfig assertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
        return this;
    }

    public SyntheticsAPITestConfig addAssertionsItem(SyntheticsAssertion assertionsItem) {
        if (this.assertions == null) {
            this.assertions = new ArrayList<SyntheticsAssertion>();
        }
        this.assertions.add(assertionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[]", value="Array of assertions used for the test.")
    @JsonProperty(value="assertions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsAssertion> getAssertions() {
        return this.assertions;
    }

    public void setAssertions(List<SyntheticsAssertion> assertions) {
        this.assertions = assertions;
    }

    public SyntheticsAPITestConfig configVariables(List<SyntheticsConfigVariable> configVariables) {
        this.configVariables = configVariables;
        return this;
    }

    public SyntheticsAPITestConfig addConfigVariablesItem(SyntheticsConfigVariable configVariablesItem) {
        if (this.configVariables == null) {
            this.configVariables = new ArrayList<SyntheticsConfigVariable>();
        }
        this.configVariables.add(configVariablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of variables used for the test.")
    @JsonProperty(value="configVariables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsConfigVariable> getConfigVariables() {
        return this.configVariables;
    }

    public void setConfigVariables(List<SyntheticsConfigVariable> configVariables) {
        this.configVariables = configVariables;
    }

    public SyntheticsAPITestConfig request(SyntheticsTestRequest request) {
        this.request = request;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="request")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestRequest getRequest() {
        return this.request;
    }

    public void setRequest(SyntheticsTestRequest request) {
        this.request = request;
    }

    public SyntheticsAPITestConfig steps(List<SyntheticsAPIStep> steps) {
        this.steps = steps;
        return this;
    }

    public SyntheticsAPITestConfig addStepsItem(SyntheticsAPIStep stepsItem) {
        if (this.steps == null) {
            this.steps = new ArrayList<SyntheticsAPIStep>();
        }
        this.steps.add(stepsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the test subtype is `multi`, the steps of the test.")
    @JsonProperty(value="steps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsAPIStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<SyntheticsAPIStep> steps) {
        this.steps = steps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsAPITestConfig syntheticsAPITestConfig = (SyntheticsAPITestConfig)o;
        return Objects.equals(this.assertions, syntheticsAPITestConfig.assertions) && Objects.equals(this.configVariables, syntheticsAPITestConfig.configVariables) && Objects.equals(this.request, syntheticsAPITestConfig.request) && Objects.equals(this.steps, syntheticsAPITestConfig.steps);
    }

    public int hashCode() {
        return Objects.hash(this.assertions, this.configVariables, this.request, this.steps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsAPITestConfig {\n");
        sb.append("    assertions: ").append(this.toIndentedString(this.assertions)).append("\n");
        sb.append("    configVariables: ").append(this.toIndentedString(this.configVariables)).append("\n");
        sb.append("    request: ").append(this.toIndentedString(this.request)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

