/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.SLOWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTimeWindows;
import com.datadog.api.v1.client.model.WidgetViewMode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Use the SLO and uptime widget to track your SLOs (Service Level Objectives) and uptime on screenboards and timeboards.")
@JsonPropertyOrder(value={"global_time_target", "show_error_budget", "slo_id", "time_windows", "title", "title_align", "title_size", "type", "view_mode", "view_type"})
public class SLOWidgetDefinition {
    public static final String JSON_PROPERTY_GLOBAL_TIME_TARGET = "global_time_target";
    private String globalTimeTarget;
    public static final String JSON_PROPERTY_SHOW_ERROR_BUDGET = "show_error_budget";
    private Boolean showErrorBudget;
    public static final String JSON_PROPERTY_SLO_ID = "slo_id";
    private String sloId;
    public static final String JSON_PROPERTY_TIME_WINDOWS = "time_windows";
    private List<WidgetTimeWindows> timeWindows = null;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SLOWidgetDefinitionType type = SLOWidgetDefinitionType.SLO;
    public static final String JSON_PROPERTY_VIEW_MODE = "view_mode";
    private WidgetViewMode viewMode;
    public static final String JSON_PROPERTY_VIEW_TYPE = "view_type";
    private String viewType = "detail";

    public SLOWidgetDefinition() {
    }

    @JsonCreator
    public SLOWidgetDefinition(@JsonProperty(required=true, value="type") SLOWidgetDefinitionType type, @JsonProperty(required=true, value="view_type") String viewType) {
        this.type = type;
        this.viewType = viewType;
    }

    public SLOWidgetDefinition globalTimeTarget(String globalTimeTarget) {
        this.globalTimeTarget = globalTimeTarget;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defined global time target.")
    @JsonProperty(value="global_time_target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGlobalTimeTarget() {
        return this.globalTimeTarget;
    }

    public void setGlobalTimeTarget(String globalTimeTarget) {
        this.globalTimeTarget = globalTimeTarget;
    }

    public SLOWidgetDefinition showErrorBudget(Boolean showErrorBudget) {
        this.showErrorBudget = showErrorBudget;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defined error budget.")
    @JsonProperty(value="show_error_budget")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowErrorBudget() {
        return this.showErrorBudget;
    }

    public void setShowErrorBudget(Boolean showErrorBudget) {
        this.showErrorBudget = showErrorBudget;
    }

    public SLOWidgetDefinition sloId(String sloId) {
        this.sloId = sloId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the SLO displayed.")
    @JsonProperty(value="slo_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSloId() {
        return this.sloId;
    }

    public void setSloId(String sloId) {
        this.sloId = sloId;
    }

    public SLOWidgetDefinition timeWindows(List<WidgetTimeWindows> timeWindows) {
        this.timeWindows = timeWindows;
        return this;
    }

    public SLOWidgetDefinition addTimeWindowsItem(WidgetTimeWindows timeWindowsItem) {
        if (this.timeWindows == null) {
            this.timeWindows = new ArrayList<WidgetTimeWindows>();
        }
        this.timeWindows.add(timeWindowsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Times being monitored.")
    @JsonProperty(value="time_windows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetTimeWindows> getTimeWindows() {
        return this.timeWindows;
    }

    public void setTimeWindows(List<WidgetTimeWindows> timeWindows) {
        this.timeWindows = timeWindows;
    }

    public SLOWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public SLOWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public SLOWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public SLOWidgetDefinition type(SLOWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SLOWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(SLOWidgetDefinitionType type) {
        this.type = type;
    }

    public SLOWidgetDefinition viewMode(WidgetViewMode viewMode) {
        this.viewMode = viewMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="view_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(WidgetViewMode viewMode) {
        this.viewMode = viewMode;
    }

    public SLOWidgetDefinition viewType(String viewType) {
        this.viewType = viewType;
        return this;
    }

    @ApiModelProperty(example="detail", required=true, value="Type of view displayed by the widget.")
    @JsonProperty(value="view_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOWidgetDefinition slOWidgetDefinition = (SLOWidgetDefinition)o;
        return Objects.equals(this.globalTimeTarget, slOWidgetDefinition.globalTimeTarget) && Objects.equals(this.showErrorBudget, slOWidgetDefinition.showErrorBudget) && Objects.equals(this.sloId, slOWidgetDefinition.sloId) && Objects.equals(this.timeWindows, slOWidgetDefinition.timeWindows) && Objects.equals(this.title, slOWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)slOWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, slOWidgetDefinition.titleSize) && Objects.equals((Object)this.type, (Object)slOWidgetDefinition.type) && Objects.equals((Object)this.viewMode, (Object)slOWidgetDefinition.viewMode) && Objects.equals(this.viewType, slOWidgetDefinition.viewType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.globalTimeTarget, this.showErrorBudget, this.sloId, this.timeWindows, this.title, this.titleAlign, this.titleSize, this.type, this.viewMode, this.viewType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOWidgetDefinition {\n");
        sb.append("    globalTimeTarget: ").append(this.toIndentedString(this.globalTimeTarget)).append("\n");
        sb.append("    showErrorBudget: ").append(this.toIndentedString(this.showErrorBudget)).append("\n");
        sb.append("    sloId: ").append(this.toIndentedString(this.sloId)).append("\n");
        sb.append("    timeWindows: ").append(this.toIndentedString(this.timeWindows)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    viewMode: ").append(this.toIndentedString((Object)this.viewMode)).append("\n");
        sb.append("    viewType: ").append(this.toIndentedString(this.viewType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

