/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogStreamWidgetDefinitionType;
import com.datadog.api.v1.client.model.WidgetFieldSort;
import com.datadog.api.v1.client.model.WidgetMessageDisplay;
import com.datadog.api.v1.client.model.WidgetTextAlign;
import com.datadog.api.v1.client.model.WidgetTime;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The Log Stream displays a log flow matching the defined query. Only available on FREE layout dashboards.")
@JsonPropertyOrder(value={"columns", "indexes", "logset", "message_display", "query", "show_date_column", "show_message_column", "sort", "time", "title", "title_align", "title_size", "type"})
public class LogStreamWidgetDefinition {
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    private List<String> columns = null;
    public static final String JSON_PROPERTY_INDEXES = "indexes";
    private List<String> indexes = null;
    public static final String JSON_PROPERTY_LOGSET = "logset";
    private String logset;
    public static final String JSON_PROPERTY_MESSAGE_DISPLAY = "message_display";
    private WidgetMessageDisplay messageDisplay;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_SHOW_DATE_COLUMN = "show_date_column";
    private Boolean showDateColumn;
    public static final String JSON_PROPERTY_SHOW_MESSAGE_COLUMN = "show_message_column";
    private Boolean showMessageColumn;
    public static final String JSON_PROPERTY_SORT = "sort";
    private WidgetFieldSort sort;
    public static final String JSON_PROPERTY_TIME = "time";
    private WidgetTime time;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_TITLE_ALIGN = "title_align";
    private WidgetTextAlign titleAlign;
    public static final String JSON_PROPERTY_TITLE_SIZE = "title_size";
    private String titleSize;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogStreamWidgetDefinitionType type = LogStreamWidgetDefinitionType.LOG_STREAM;

    public LogStreamWidgetDefinition() {
    }

    @JsonCreator
    public LogStreamWidgetDefinition(@JsonProperty(required=true, value="type") LogStreamWidgetDefinitionType type) {
        this.type = type;
    }

    public LogStreamWidgetDefinition columns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    public LogStreamWidgetDefinition addColumnsItem(String columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<String>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Which columns to display on the widget.")
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public LogStreamWidgetDefinition indexes(List<String> indexes) {
        this.indexes = indexes;
        return this;
    }

    public LogStreamWidgetDefinition addIndexesItem(String indexesItem) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<String>();
        }
        this.indexes.add(indexesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"days-3\",\"days-7\"]", value="An array of index names to query in the stream. Use [] to query all indexes at once.")
    @JsonProperty(value="indexes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<String> indexes) {
        this.indexes = indexes;
    }

    public LogStreamWidgetDefinition logset(String logset) {
        this.logset = logset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the log set to use.")
    @JsonProperty(value="logset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogset() {
        return this.logset;
    }

    public void setLogset(String logset) {
        this.logset = logset;
    }

    public LogStreamWidgetDefinition messageDisplay(WidgetMessageDisplay messageDisplay) {
        this.messageDisplay = messageDisplay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="message_display")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetMessageDisplay getMessageDisplay() {
        return this.messageDisplay;
    }

    public void setMessageDisplay(WidgetMessageDisplay messageDisplay) {
        this.messageDisplay = messageDisplay;
    }

    public LogStreamWidgetDefinition query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Query to filter the log stream with.")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public LogStreamWidgetDefinition showDateColumn(Boolean showDateColumn) {
        this.showDateColumn = showDateColumn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to show the date column or not")
    @JsonProperty(value="show_date_column")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowDateColumn() {
        return this.showDateColumn;
    }

    public void setShowDateColumn(Boolean showDateColumn) {
        this.showDateColumn = showDateColumn;
    }

    public LogStreamWidgetDefinition showMessageColumn(Boolean showMessageColumn) {
        this.showMessageColumn = showMessageColumn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to show the message column or not")
    @JsonProperty(value="show_message_column")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowMessageColumn() {
        return this.showMessageColumn;
    }

    public void setShowMessageColumn(Boolean showMessageColumn) {
        this.showMessageColumn = showMessageColumn;
    }

    public LogStreamWidgetDefinition sort(WidgetFieldSort sort) {
        this.sort = sort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetFieldSort getSort() {
        return this.sort;
    }

    public void setSort(WidgetFieldSort sort) {
        this.sort = sort;
    }

    public LogStreamWidgetDefinition time(WidgetTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="time")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTime getTime() {
        return this.time;
    }

    public void setTime(WidgetTime time) {
        this.time = time;
    }

    public LogStreamWidgetDefinition title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Title of the widget.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LogStreamWidgetDefinition titleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="title_align")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetTextAlign getTitleAlign() {
        return this.titleAlign;
    }

    public void setTitleAlign(WidgetTextAlign titleAlign) {
        this.titleAlign = titleAlign;
    }

    public LogStreamWidgetDefinition titleSize(String titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of the title.")
    @JsonProperty(value="title_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitleSize() {
        return this.titleSize;
    }

    public void setTitleSize(String titleSize) {
        this.titleSize = titleSize;
    }

    public LogStreamWidgetDefinition type(LogStreamWidgetDefinitionType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogStreamWidgetDefinitionType getType() {
        return this.type;
    }

    public void setType(LogStreamWidgetDefinitionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogStreamWidgetDefinition logStreamWidgetDefinition = (LogStreamWidgetDefinition)o;
        return Objects.equals(this.columns, logStreamWidgetDefinition.columns) && Objects.equals(this.indexes, logStreamWidgetDefinition.indexes) && Objects.equals(this.logset, logStreamWidgetDefinition.logset) && Objects.equals((Object)this.messageDisplay, (Object)logStreamWidgetDefinition.messageDisplay) && Objects.equals(this.query, logStreamWidgetDefinition.query) && Objects.equals(this.showDateColumn, logStreamWidgetDefinition.showDateColumn) && Objects.equals(this.showMessageColumn, logStreamWidgetDefinition.showMessageColumn) && Objects.equals(this.sort, logStreamWidgetDefinition.sort) && Objects.equals(this.time, logStreamWidgetDefinition.time) && Objects.equals(this.title, logStreamWidgetDefinition.title) && Objects.equals((Object)this.titleAlign, (Object)logStreamWidgetDefinition.titleAlign) && Objects.equals(this.titleSize, logStreamWidgetDefinition.titleSize) && Objects.equals((Object)this.type, (Object)logStreamWidgetDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columns, this.indexes, this.logset, this.messageDisplay, this.query, this.showDateColumn, this.showMessageColumn, this.sort, this.time, this.title, this.titleAlign, this.titleSize, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogStreamWidgetDefinition {\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    indexes: ").append(this.toIndentedString(this.indexes)).append("\n");
        sb.append("    logset: ").append(this.toIndentedString(this.logset)).append("\n");
        sb.append("    messageDisplay: ").append(this.toIndentedString((Object)this.messageDisplay)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    showDateColumn: ").append(this.toIndentedString(this.showDateColumn)).append("\n");
        sb.append("    showMessageColumn: ").append(this.toIndentedString(this.showMessageColumn)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    titleAlign: ").append(this.toIndentedString((Object)this.titleAlign)).append("\n");
        sb.append("    titleSize: ").append(this.toIndentedString(this.titleSize)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

