/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.DashboardLayoutType;
import com.datadog.api.v1.client.model.DashboardReflowType;
import com.datadog.api.v1.client.model.DashboardTemplateVariable;
import com.datadog.api.v1.client.model.DashboardTemplateVariablePreset;
import com.datadog.api.v1.client.model.Widget;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="A dashboard is Datadog\u2019s tool for visually tracking, analyzing, and displaying key performance metrics, which enable you to monitor the health of your infrastructure.")
@JsonPropertyOrder(value={"author_handle", "created_at", "description", "id", "is_read_only", "layout_type", "modified_at", "notify_list", "reflow_type", "restricted_roles", "template_variable_presets", "template_variables", "title", "url", "widgets"})
public class Dashboard {
    public static final String JSON_PROPERTY_AUTHOR_HANDLE = "author_handle";
    private String authorHandle;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IS_READ_ONLY = "is_read_only";
    private Boolean isReadOnly = false;
    public static final String JSON_PROPERTY_LAYOUT_TYPE = "layout_type";
    private DashboardLayoutType layoutType;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private OffsetDateTime modifiedAt;
    public static final String JSON_PROPERTY_NOTIFY_LIST = "notify_list";
    private JsonNullable<List<String>> notifyList = JsonNullable.undefined();
    public static final String JSON_PROPERTY_REFLOW_TYPE = "reflow_type";
    private DashboardReflowType reflowType;
    public static final String JSON_PROPERTY_RESTRICTED_ROLES = "restricted_roles";
    private List<String> restrictedRoles = null;
    public static final String JSON_PROPERTY_TEMPLATE_VARIABLE_PRESETS = "template_variable_presets";
    private JsonNullable<List<DashboardTemplateVariablePreset>> templateVariablePresets = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TEMPLATE_VARIABLES = "template_variables";
    private JsonNullable<List<DashboardTemplateVariable>> templateVariables = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_WIDGETS = "widgets";
    private List<Widget> widgets = new ArrayList<Widget>();

    public Dashboard() {
    }

    @JsonCreator
    public Dashboard(@JsonProperty(required=true, value="layout_type") DashboardLayoutType layoutType, @JsonProperty(required=true, value="title") String title, @JsonProperty(required=true, value="widgets") List<Widget> widgets) {
        this.layoutType = layoutType;
        this.title = title;
        this.widgets = widgets;
    }

    @Nullable
    @ApiModelProperty(example="test@datadoghq.com", value="Identifier of the dashboard author.")
    @JsonProperty(value="author_handle")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorHandle() {
        return this.authorHandle;
    }

    @Nullable
    @ApiModelProperty(value="Creation date of the dashboard.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Dashboard description(String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the dashboard.")
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(String description) {
        this.description = JsonNullable.of((Object)description);
    }

    @Nullable
    @ApiModelProperty(example="123-abc-456", value="ID of the dashboard.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public Dashboard isReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether this dashboard is read-only. If True, only the author and admins can make changes to it.")
    @JsonProperty(value="is_read_only")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    public void setIsReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public Dashboard layoutType(DashboardLayoutType layoutType) {
        this.layoutType = layoutType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="layout_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DashboardLayoutType getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(DashboardLayoutType layoutType) {
        this.layoutType = layoutType;
    }

    @Nullable
    @ApiModelProperty(value="Modification date of the dashboard.")
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public Dashboard notifyList(List<String> notifyList) {
        this.notifyList = JsonNullable.of(notifyList);
        return this;
    }

    public Dashboard addNotifyListItem(String notifyListItem) {
        if (this.notifyList == null || !this.notifyList.isPresent()) {
            this.notifyList = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.notifyList.get()).add(notifyListItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of handles of users to notify when changes are made to this dashboard.")
    @JsonIgnore
    public List<String> getNotifyList() {
        return (List)this.notifyList.orElse(null);
    }

    @JsonProperty(value="notify_list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getNotifyList_JsonNullable() {
        return this.notifyList;
    }

    @JsonProperty(value="notify_list")
    public void setNotifyList_JsonNullable(JsonNullable<List<String>> notifyList) {
        this.notifyList = notifyList;
    }

    public void setNotifyList(List<String> notifyList) {
        this.notifyList = JsonNullable.of(notifyList);
    }

    public Dashboard reflowType(DashboardReflowType reflowType) {
        this.reflowType = reflowType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reflow_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DashboardReflowType getReflowType() {
        return this.reflowType;
    }

    public void setReflowType(DashboardReflowType reflowType) {
        this.reflowType = reflowType;
    }

    public Dashboard restrictedRoles(List<String> restrictedRoles) {
        this.restrictedRoles = restrictedRoles;
        return this;
    }

    public Dashboard addRestrictedRolesItem(String restrictedRolesItem) {
        if (this.restrictedRoles == null) {
            this.restrictedRoles = new ArrayList<String>();
        }
        this.restrictedRoles.add(restrictedRolesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of role identifiers. Only the author and users associated with at least one of these roles can edit this dashboard. Overrides the `is_read_only` property if both are present. **This feature is currently in beta.**")
    @JsonProperty(value="restricted_roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getRestrictedRoles() {
        return this.restrictedRoles;
    }

    public void setRestrictedRoles(List<String> restrictedRoles) {
        this.restrictedRoles = restrictedRoles;
    }

    public Dashboard templateVariablePresets(List<DashboardTemplateVariablePreset> templateVariablePresets) {
        this.templateVariablePresets = JsonNullable.of(templateVariablePresets);
        return this;
    }

    public Dashboard addTemplateVariablePresetsItem(DashboardTemplateVariablePreset templateVariablePresetsItem) {
        if (this.templateVariablePresets == null || !this.templateVariablePresets.isPresent()) {
            this.templateVariablePresets = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.templateVariablePresets.get()).add(templateVariablePresetsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of template variables saved views.")
    @JsonIgnore
    public List<DashboardTemplateVariablePreset> getTemplateVariablePresets() {
        return (List)this.templateVariablePresets.orElse(null);
    }

    @JsonProperty(value="template_variable_presets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<DashboardTemplateVariablePreset>> getTemplateVariablePresets_JsonNullable() {
        return this.templateVariablePresets;
    }

    @JsonProperty(value="template_variable_presets")
    public void setTemplateVariablePresets_JsonNullable(JsonNullable<List<DashboardTemplateVariablePreset>> templateVariablePresets) {
        this.templateVariablePresets = templateVariablePresets;
    }

    public void setTemplateVariablePresets(List<DashboardTemplateVariablePreset> templateVariablePresets) {
        this.templateVariablePresets = JsonNullable.of(templateVariablePresets);
    }

    public Dashboard templateVariables(List<DashboardTemplateVariable> templateVariables) {
        this.templateVariables = JsonNullable.of(templateVariables);
        return this;
    }

    public Dashboard addTemplateVariablesItem(DashboardTemplateVariable templateVariablesItem) {
        if (this.templateVariables == null || !this.templateVariables.isPresent()) {
            this.templateVariables = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.templateVariables.get()).add(templateVariablesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of template variables for this dashboard.")
    @JsonIgnore
    public List<DashboardTemplateVariable> getTemplateVariables() {
        return (List)this.templateVariables.orElse(null);
    }

    @JsonProperty(value="template_variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<DashboardTemplateVariable>> getTemplateVariables_JsonNullable() {
        return this.templateVariables;
    }

    @JsonProperty(value="template_variables")
    public void setTemplateVariables_JsonNullable(JsonNullable<List<DashboardTemplateVariable>> templateVariables) {
        this.templateVariables = templateVariables;
    }

    public void setTemplateVariables(List<DashboardTemplateVariable> templateVariables) {
        this.templateVariables = JsonNullable.of(templateVariables);
    }

    public Dashboard title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="", required=true, value="Title of the dashboard.")
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Nullable
    @ApiModelProperty(example="/dashboard/123-abc-456/example-dashboard-title", value="The URL of the dashboard.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public Dashboard widgets(List<Widget> widgets) {
        this.widgets = widgets;
        return this;
    }

    public Dashboard addWidgetsItem(Widget widgetsItem) {
        this.widgets.add(widgetsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"definition\":{\"requests\":{\"fill\":{\"q\":\"system.cpu.user\"}},\"type\":\"hostmap\"}}]", required=true, value="List of widgets to display on the dashboard.")
    @JsonProperty(value="widgets")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(List<Widget> widgets) {
        this.widgets = widgets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dashboard dashboard = (Dashboard)o;
        return Objects.equals(this.authorHandle, dashboard.authorHandle) && Objects.equals(this.createdAt, dashboard.createdAt) && Objects.equals(this.description, dashboard.description) && Objects.equals(this.id, dashboard.id) && Objects.equals(this.isReadOnly, dashboard.isReadOnly) && Objects.equals((Object)this.layoutType, (Object)dashboard.layoutType) && Objects.equals(this.modifiedAt, dashboard.modifiedAt) && Objects.equals(this.notifyList, dashboard.notifyList) && Objects.equals((Object)this.reflowType, (Object)dashboard.reflowType) && Objects.equals(this.restrictedRoles, dashboard.restrictedRoles) && Objects.equals(this.templateVariablePresets, dashboard.templateVariablePresets) && Objects.equals(this.templateVariables, dashboard.templateVariables) && Objects.equals(this.title, dashboard.title) && Objects.equals(this.url, dashboard.url) && Objects.equals(this.widgets, dashboard.widgets);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorHandle, this.createdAt, this.description, this.id, this.isReadOnly, this.layoutType, this.modifiedAt, this.notifyList, this.reflowType, this.restrictedRoles, this.templateVariablePresets, this.templateVariables, this.title, this.url, this.widgets});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Dashboard {\n");
        sb.append("    authorHandle: ").append(this.toIndentedString(this.authorHandle)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isReadOnly: ").append(this.toIndentedString(this.isReadOnly)).append("\n");
        sb.append("    layoutType: ").append(this.toIndentedString((Object)this.layoutType)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    notifyList: ").append(this.toIndentedString(this.notifyList)).append("\n");
        sb.append("    reflowType: ").append(this.toIndentedString((Object)this.reflowType)).append("\n");
        sb.append("    restrictedRoles: ").append(this.toIndentedString(this.restrictedRoles)).append("\n");
        sb.append("    templateVariablePresets: ").append(this.toIndentedString(this.templateVariablePresets)).append("\n");
        sb.append("    templateVariables: ").append(this.toIndentedString(this.templateVariables)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    widgets: ").append(this.toIndentedString(this.widgets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

