/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.NotebookCreateRequest;
import com.datadog.api.v1.client.model.NotebookResponse;
import com.datadog.api.v1.client.model.NotebookUpdateRequest;
import com.datadog.api.v1.client.model.NotebooksResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class NotebooksApi {
    private ApiClient apiClient;

    public NotebooksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NotebooksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public NotebookResponse createNotebook(NotebookCreateRequest body) throws ApiException {
        return this.createNotebookWithHttpInfo(body).getData();
    }

    public ApiResponse<NotebookResponse> createNotebookWithHttpInfo(NotebookCreateRequest body) throws ApiException {
        NotebookCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createNotebook");
        }
        String localVarPath = "/api/v1/notebooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createNotebook");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<NotebookResponse> localVarReturnType = new GenericType<NotebookResponse>(){};
        return this.apiClient.invokeAPI("NotebooksApi.createNotebook", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteNotebook(Long notebookId) throws ApiException {
        this.deleteNotebookWithHttpInfo(notebookId);
    }

    public ApiResponse<Void> deleteNotebookWithHttpInfo(Long notebookId) throws ApiException {
        Object localVarPostBody = null;
        if (notebookId == null) {
            throw new ApiException(400, "Missing the required parameter 'notebookId' when calling deleteNotebook");
        }
        String localVarPath = "/api/v1/notebooks/{notebook_id}".replaceAll("\\{notebook_id\\}", this.apiClient.escapeString(notebookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteNotebook");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("NotebooksApi.deleteNotebook", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public NotebookResponse getNotebook(Long notebookId) throws ApiException {
        return this.getNotebookWithHttpInfo(notebookId).getData();
    }

    public ApiResponse<NotebookResponse> getNotebookWithHttpInfo(Long notebookId) throws ApiException {
        Object localVarPostBody = null;
        if (notebookId == null) {
            throw new ApiException(400, "Missing the required parameter 'notebookId' when calling getNotebook");
        }
        String localVarPath = "/api/v1/notebooks/{notebook_id}".replaceAll("\\{notebook_id\\}", this.apiClient.escapeString(notebookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getNotebook");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<NotebookResponse> localVarReturnType = new GenericType<NotebookResponse>(){};
        return this.apiClient.invokeAPI("NotebooksApi.getNotebook", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public NotebooksResponse listNotebooks() throws ApiException {
        return this.listNotebooksWithHttpInfo(new ListNotebooksOptionalParameters()).getData();
    }

    public NotebooksResponse listNotebooks(ListNotebooksOptionalParameters parameters) throws ApiException {
        return this.listNotebooksWithHttpInfo(parameters).getData();
    }

    public ApiResponse<NotebooksResponse> listNotebooksWithHttpInfo(ListNotebooksOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String authorHandle = parameters.authorHandle;
        String excludeAuthorHandle = parameters.excludeAuthorHandle;
        Long start = parameters.start;
        Long count = parameters.count;
        String sortField = parameters.sortField;
        String sortDir = parameters.sortDir;
        String query = parameters.query;
        Boolean includeCells = parameters.includeCells;
        String localVarPath = "/api/v1/notebooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "author_handle", authorHandle));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "exclude_author_handle", excludeAuthorHandle));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "count", count));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_field", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_cells", includeCells));
        localVarHeaderParams.put("DD-OPERATION-ID", "listNotebooks");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<NotebooksResponse> localVarReturnType = new GenericType<NotebooksResponse>(){};
        return this.apiClient.invokeAPI("NotebooksApi.listNotebooks", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public NotebookResponse updateNotebook(Long notebookId, NotebookUpdateRequest body) throws ApiException {
        return this.updateNotebookWithHttpInfo(notebookId, body).getData();
    }

    public ApiResponse<NotebookResponse> updateNotebookWithHttpInfo(Long notebookId, NotebookUpdateRequest body) throws ApiException {
        NotebookUpdateRequest localVarPostBody = body;
        if (notebookId == null) {
            throw new ApiException(400, "Missing the required parameter 'notebookId' when calling updateNotebook");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateNotebook");
        }
        String localVarPath = "/api/v1/notebooks/{notebook_id}".replaceAll("\\{notebook_id\\}", this.apiClient.escapeString(notebookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateNotebook");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<NotebookResponse> localVarReturnType = new GenericType<NotebookResponse>(){};
        return this.apiClient.invokeAPI("NotebooksApi.updateNotebook", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListNotebooksOptionalParameters {
        private String authorHandle;
        private String excludeAuthorHandle;
        private Long start;
        private Long count;
        private String sortField;
        private String sortDir;
        private String query;
        private Boolean includeCells;

        public ListNotebooksOptionalParameters authorHandle(String authorHandle) {
            this.authorHandle = authorHandle;
            return this;
        }

        public ListNotebooksOptionalParameters excludeAuthorHandle(String excludeAuthorHandle) {
            this.excludeAuthorHandle = excludeAuthorHandle;
            return this;
        }

        public ListNotebooksOptionalParameters start(Long start) {
            this.start = start;
            return this;
        }

        public ListNotebooksOptionalParameters count(Long count) {
            this.count = count;
            return this;
        }

        public ListNotebooksOptionalParameters sortField(String sortField) {
            this.sortField = sortField;
            return this;
        }

        public ListNotebooksOptionalParameters sortDir(String sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public ListNotebooksOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public ListNotebooksOptionalParameters includeCells(Boolean includeCells) {
            this.includeCells = includeCells;
            return this;
        }
    }
}

