/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.AWSAccount;
import com.datadog.api.v1.client.model.AWSAccountCreateResponse;
import com.datadog.api.v1.client.model.AWSAccountDeleteRequest;
import com.datadog.api.v1.client.model.AWSAccountListResponse;
import com.datadog.api.v1.client.model.AWSTagFilterCreateRequest;
import com.datadog.api.v1.client.model.AWSTagFilterDeleteRequest;
import com.datadog.api.v1.client.model.AWSTagFilterListResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class AwsIntegrationApi {
    private ApiClient apiClient;

    public AwsIntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AwsIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AWSAccountCreateResponse createAWSAccount(AWSAccount body) throws ApiException {
        return this.createAWSAccountWithHttpInfo(body).getData();
    }

    public ApiResponse<AWSAccountCreateResponse> createAWSAccountWithHttpInfo(AWSAccount body) throws ApiException {
        AWSAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAWSAccount");
        }
        String localVarPath = "/api/v1/integration/aws";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAWSAccount");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<AWSAccountCreateResponse> localVarReturnType = new GenericType<AWSAccountCreateResponse>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.createAWSAccount", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Object createAWSTagFilter(AWSTagFilterCreateRequest body) throws ApiException {
        return this.createAWSTagFilterWithHttpInfo(body).getData();
    }

    public ApiResponse<Object> createAWSTagFilterWithHttpInfo(AWSTagFilterCreateRequest body) throws ApiException {
        AWSTagFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAWSTagFilter");
        }
        String localVarPath = "/api/v1/integration/aws/filtering";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAWSTagFilter");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.createAWSTagFilter", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public AWSAccountCreateResponse createNewAWSExternalID(AWSAccount body) throws ApiException {
        return this.createNewAWSExternalIDWithHttpInfo(body).getData();
    }

    public ApiResponse<AWSAccountCreateResponse> createNewAWSExternalIDWithHttpInfo(AWSAccount body) throws ApiException {
        AWSAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createNewAWSExternalID");
        }
        String localVarPath = "/api/v1/integration/aws/generate_new_external_id";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createNewAWSExternalID");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<AWSAccountCreateResponse> localVarReturnType = new GenericType<AWSAccountCreateResponse>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.createNewAWSExternalID", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Object deleteAWSAccount(AWSAccountDeleteRequest body) throws ApiException {
        return this.deleteAWSAccountWithHttpInfo(body).getData();
    }

    public ApiResponse<Object> deleteAWSAccountWithHttpInfo(AWSAccountDeleteRequest body) throws ApiException {
        AWSAccountDeleteRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteAWSAccount");
        }
        String localVarPath = "/api/v1/integration/aws";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAWSAccount");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.deleteAWSAccount", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Object deleteAWSTagFilter(AWSTagFilterDeleteRequest body) throws ApiException {
        return this.deleteAWSTagFilterWithHttpInfo(body).getData();
    }

    public ApiResponse<Object> deleteAWSTagFilterWithHttpInfo(AWSTagFilterDeleteRequest body) throws ApiException {
        AWSTagFilterDeleteRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteAWSTagFilter");
        }
        String localVarPath = "/api/v1/integration/aws/filtering";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAWSTagFilter");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.deleteAWSTagFilter", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public AWSAccountListResponse listAWSAccounts() throws ApiException {
        return this.listAWSAccountsWithHttpInfo(new ListAWSAccountsOptionalParameters()).getData();
    }

    public AWSAccountListResponse listAWSAccounts(ListAWSAccountsOptionalParameters parameters) throws ApiException {
        return this.listAWSAccountsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<AWSAccountListResponse> listAWSAccountsWithHttpInfo(ListAWSAccountsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String accountId = parameters.accountId;
        String roleName = parameters.roleName;
        String accessKeyId = parameters.accessKeyId;
        String localVarPath = "/api/v1/integration/aws";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "role_name", roleName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "access_key_id", accessKeyId));
        localVarHeaderParams.put("DD-OPERATION-ID", "listAWSAccounts");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<AWSAccountListResponse> localVarReturnType = new GenericType<AWSAccountListResponse>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.listAWSAccounts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public AWSTagFilterListResponse listAWSTagFilters(String accountId) throws ApiException {
        return this.listAWSTagFiltersWithHttpInfo(accountId).getData();
    }

    public ApiResponse<AWSTagFilterListResponse> listAWSTagFiltersWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listAWSTagFilters");
        }
        String localVarPath = "/api/v1/integration/aws/filtering";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarHeaderParams.put("DD-OPERATION-ID", "listAWSTagFilters");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<AWSTagFilterListResponse> localVarReturnType = new GenericType<AWSTagFilterListResponse>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.listAWSTagFilters", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public List<String> listAvailableAWSNamespaces() throws ApiException {
        return this.listAvailableAWSNamespacesWithHttpInfo().getData();
    }

    public ApiResponse<List<String>> listAvailableAWSNamespacesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/aws/available_namespace_rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listAvailableAWSNamespaces");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<List<String>> localVarReturnType = new GenericType<List<String>>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.listAvailableAWSNamespaces", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Object updateAWSAccount(AWSAccount body) throws ApiException {
        return this.updateAWSAccountWithHttpInfo(body, new UpdateAWSAccountOptionalParameters()).getData();
    }

    public Object updateAWSAccount(AWSAccount body, UpdateAWSAccountOptionalParameters parameters) throws ApiException {
        return this.updateAWSAccountWithHttpInfo(body, parameters).getData();
    }

    public ApiResponse<Object> updateAWSAccountWithHttpInfo(AWSAccount body, UpdateAWSAccountOptionalParameters parameters) throws ApiException {
        AWSAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAWSAccount");
        }
        String accountId = parameters.accountId;
        String roleName = parameters.roleName;
        String accessKeyId = parameters.accessKeyId;
        String localVarPath = "/api/v1/integration/aws";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "role_name", roleName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "access_key_id", accessKeyId));
        localVarHeaderParams.put("DD-OPERATION-ID", "updateAWSAccount");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.updateAWSAccount", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class UpdateAWSAccountOptionalParameters {
        private String accountId;
        private String roleName;
        private String accessKeyId;

        public UpdateAWSAccountOptionalParameters accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public UpdateAWSAccountOptionalParameters roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public UpdateAWSAccountOptionalParameters accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }
    }

    public static class ListAWSAccountsOptionalParameters {
        private String accountId;
        private String roleName;
        private String accessKeyId;

        public ListAWSAccountsOptionalParameters accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public ListAWSAccountsOptionalParameters roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public ListAWSAccountsOptionalParameters accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }
    }
}

