/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.IncidentCreateRequest;
import com.datadog.api.v2.client.model.IncidentRelatedObject;
import com.datadog.api.v2.client.model.IncidentResponse;
import com.datadog.api.v2.client.model.IncidentUpdateRequest;
import com.datadog.api.v2.client.model.IncidentsResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class IncidentsApi {
    private ApiClient apiClient;

    public IncidentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IncidentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IncidentResponse createIncident(IncidentCreateRequest body) throws ApiException {
        return this.createIncidentWithHttpInfo(body).getData();
    }

    public ApiResponse<IncidentResponse> createIncidentWithHttpInfo(IncidentCreateRequest body) throws ApiException {
        IncidentCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncident");
        }
        String localVarPath = "/api/v2/incidents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createIncident");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentResponse> localVarReturnType = new GenericType<IncidentResponse>(){};
        return this.apiClient.invokeAPI("IncidentsApi.createIncident", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public void deleteIncident(String incidentId) throws ApiException {
        this.deleteIncidentWithHttpInfo(incidentId);
    }

    public ApiResponse<Void> deleteIncidentWithHttpInfo(String incidentId) throws ApiException {
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling deleteIncident");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteIncident");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("IncidentsApi.deleteIncident", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public IncidentResponse getIncident(String incidentId) throws ApiException {
        return this.getIncidentWithHttpInfo(incidentId, new GetIncidentOptionalParameters()).getData();
    }

    public IncidentResponse getIncident(String incidentId, GetIncidentOptionalParameters parameters) throws ApiException {
        return this.getIncidentWithHttpInfo(incidentId, parameters).getData();
    }

    public ApiResponse<IncidentResponse> getIncidentWithHttpInfo(String incidentId, GetIncidentOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling getIncident");
        }
        List include = parameters.include;
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIncident");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentResponse> localVarReturnType = new GenericType<IncidentResponse>(){};
        return this.apiClient.invokeAPI("IncidentsApi.getIncident", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public IncidentsResponse listIncidents() throws ApiException {
        return this.listIncidentsWithHttpInfo(new ListIncidentsOptionalParameters()).getData();
    }

    public IncidentsResponse listIncidents(ListIncidentsOptionalParameters parameters) throws ApiException {
        return this.listIncidentsWithHttpInfo(parameters).getData();
    }

    public ApiResponse<IncidentsResponse> listIncidentsWithHttpInfo(ListIncidentsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        List include = parameters.include;
        Long pageSize = parameters.pageSize;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/incidents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarHeaderParams.put("DD-OPERATION-ID", "listIncidents");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentsResponse> localVarReturnType = new GenericType<IncidentsResponse>(){};
        return this.apiClient.invokeAPI("IncidentsApi.listIncidents", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public IncidentResponse updateIncident(String incidentId, IncidentUpdateRequest body) throws ApiException {
        return this.updateIncidentWithHttpInfo(incidentId, body).getData();
    }

    public ApiResponse<IncidentResponse> updateIncidentWithHttpInfo(String incidentId, IncidentUpdateRequest body) throws ApiException {
        IncidentUpdateRequest localVarPostBody = body;
        if (incidentId == null) {
            throw new ApiException(400, "Missing the required parameter 'incidentId' when calling updateIncident");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncident");
        }
        String localVarPath = "/api/v2/incidents/{incident_id}".replaceAll("\\{incident_id\\}", this.apiClient.escapeString(incidentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateIncident");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentResponse> localVarReturnType = new GenericType<IncidentResponse>(){};
        return this.apiClient.invokeAPI("IncidentsApi.updateIncident", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class ListIncidentsOptionalParameters {
        private List<IncidentRelatedObject> include;
        private Long pageSize;
        private Long pageOffset;

        public ListIncidentsOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }

        public ListIncidentsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListIncidentsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }
    }

    public static class GetIncidentOptionalParameters {
        private List<IncidentRelatedObject> include;

        public GetIncidentOptionalParameters include(List<IncidentRelatedObject> include) {
            this.include = include;
            return this;
        }
    }
}

